// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the properties of a secret object value.
 */
@Fluent
public final class SecretObject implements JsonSerializable<SecretObject> {
    /*
     * The value of the secret. The format of this value will be determined
     * based on the type of the secret object. If the type is Opaque, the value will be
     * used as is without any modification.
     */
    private String value;

    /*
     * The type of the secret object which determines how the value of the secret object has to be
     * interpreted.
     */
    private SecretObjectType type;

    /**
     * Creates an instance of SecretObject class.
     */
    public SecretObject() {
    }

    /**
     * Get the value property: The value of the secret. The format of this value will be determined
     * based on the type of the secret object. If the type is Opaque, the value will be
     * used as is without any modification.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the secret. The format of this value will be determined
     * based on the type of the secret object. If the type is Opaque, the value will be
     * used as is without any modification.
     * 
     * @param value the value value to set.
     * @return the SecretObject object itself.
     */
    public SecretObject withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the type property: The type of the secret object which determines how the value of the secret object has to
     * be
     * interpreted.
     * 
     * @return the type value.
     */
    public SecretObjectType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the secret object which determines how the value of the secret object has to
     * be
     * interpreted.
     * 
     * @param type the type value to set.
     * @return the SecretObject object itself.
     */
    public SecretObject withType(SecretObjectType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecretObject from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecretObject if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecretObject.
     */
    public static SecretObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretObject deserializedSecretObject = new SecretObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedSecretObject.value = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSecretObject.type = SecretObjectType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecretObject;
        });
    }
}
