// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.ScopeMapInner;
import java.io.IOException;
import java.util.List;

/**
 * The result of a request to list scope maps for a container registry.
 */
@Fluent
public final class ScopeMapListResult implements JsonSerializable<ScopeMapListResult> {
    /*
     * The list of scope maps. Since this list may be incomplete, the nextLink field should be used to request the next
     * list of scope maps.
     */
    private List<ScopeMapInner> value;

    /*
     * The URI that can be used to request the next list of scope maps.
     */
    private String nextLink;

    /**
     * Creates an instance of ScopeMapListResult class.
     */
    public ScopeMapListResult() {
    }

    /**
     * Get the value property: The list of scope maps. Since this list may be incomplete, the nextLink field should be
     * used to request the next list of scope maps.
     * 
     * @return the value value.
     */
    public List<ScopeMapInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of scope maps. Since this list may be incomplete, the nextLink field should be
     * used to request the next list of scope maps.
     * 
     * @param value the value value to set.
     * @return the ScopeMapListResult object itself.
     */
    public ScopeMapListResult withValue(List<ScopeMapInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI that can be used to request the next list of scope maps.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI that can be used to request the next list of scope maps.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ScopeMapListResult object itself.
     */
    public ScopeMapListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScopeMapListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScopeMapListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ScopeMapListResult.
     */
    public static ScopeMapListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScopeMapListResult deserializedScopeMapListResult = new ScopeMapListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ScopeMapInner> value = reader.readArray(reader1 -> ScopeMapInner.fromJson(reader1));
                    deserializedScopeMapListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedScopeMapListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScopeMapListResult;
        });
    }
}
