// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The request parameters for scheduling a run.
 */
@Fluent
public class RunRequest implements JsonSerializable<RunRequest> {
    /*
     * The type of the run request.
     */
    private String type = "RunRequest";

    /*
     * The value that indicates whether archiving is enabled for the run or not.
     */
    private Boolean isArchiveEnabled;

    /*
     * The dedicated agent pool for the run.
     */
    private String agentPoolName;

    /*
     * The template that describes the repository and tag information for run log artifact.
     */
    private String logTemplate;

    /**
     * Creates an instance of RunRequest class.
     */
    public RunRequest() {
    }

    /**
     * Get the type property: The type of the run request.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the isArchiveEnabled property: The value that indicates whether archiving is enabled for the run or not.
     * 
     * @return the isArchiveEnabled value.
     */
    public Boolean isArchiveEnabled() {
        return this.isArchiveEnabled;
    }

    /**
     * Set the isArchiveEnabled property: The value that indicates whether archiving is enabled for the run or not.
     * 
     * @param isArchiveEnabled the isArchiveEnabled value to set.
     * @return the RunRequest object itself.
     */
    public RunRequest withIsArchiveEnabled(Boolean isArchiveEnabled) {
        this.isArchiveEnabled = isArchiveEnabled;
        return this;
    }

    /**
     * Get the agentPoolName property: The dedicated agent pool for the run.
     * 
     * @return the agentPoolName value.
     */
    public String agentPoolName() {
        return this.agentPoolName;
    }

    /**
     * Set the agentPoolName property: The dedicated agent pool for the run.
     * 
     * @param agentPoolName the agentPoolName value to set.
     * @return the RunRequest object itself.
     */
    public RunRequest withAgentPoolName(String agentPoolName) {
        this.agentPoolName = agentPoolName;
        return this;
    }

    /**
     * Get the logTemplate property: The template that describes the repository and tag information for run log
     * artifact.
     * 
     * @return the logTemplate value.
     */
    public String logTemplate() {
        return this.logTemplate;
    }

    /**
     * Set the logTemplate property: The template that describes the repository and tag information for run log
     * artifact.
     * 
     * @param logTemplate the logTemplate value to set.
     * @return the RunRequest object itself.
     */
    public RunRequest withLogTemplate(String logTemplate) {
        this.logTemplate = logTemplate;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeBooleanField("isArchiveEnabled", this.isArchiveEnabled);
        jsonWriter.writeStringField("agentPoolName", this.agentPoolName);
        jsonWriter.writeStringField("logTemplate", this.logTemplate);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunRequest if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the RunRequest.
     */
    public static RunRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("DockerBuildRequest".equals(discriminatorValue)) {
                    return DockerBuildRequest.fromJson(readerToUse.reset());
                } else if ("FileTaskRunRequest".equals(discriminatorValue)) {
                    return FileTaskRunRequest.fromJson(readerToUse.reset());
                } else if ("TaskRunRequest".equals(discriminatorValue)) {
                    return TaskRunRequest.fromJson(readerToUse.reset());
                } else if ("EncodedTaskRunRequest".equals(discriminatorValue)) {
                    return EncodedTaskRunRequest.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static RunRequest fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunRequest deserializedRunRequest = new RunRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedRunRequest.type = reader.getString();
                } else if ("isArchiveEnabled".equals(fieldName)) {
                    deserializedRunRequest.isArchiveEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("agentPoolName".equals(fieldName)) {
                    deserializedRunRequest.agentPoolName = reader.getString();
                } else if ("logTemplate".equals(fieldName)) {
                    deserializedRunRequest.logTemplate = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRunRequest;
        });
    }
}
