// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The retention policy for a container registry.
 */
@Fluent
public final class RetentionPolicy implements JsonSerializable<RetentionPolicy> {
    /*
     * The number of days to retain an untagged manifest after which it gets purged.
     */
    private Integer days;

    /*
     * The timestamp when the policy was last updated.
     */
    private OffsetDateTime lastUpdatedTime;

    /*
     * The value that indicates whether the policy is enabled or not.
     */
    private PolicyStatus status;

    /**
     * Creates an instance of RetentionPolicy class.
     */
    public RetentionPolicy() {
    }

    /**
     * Get the days property: The number of days to retain an untagged manifest after which it gets purged.
     * 
     * @return the days value.
     */
    public Integer days() {
        return this.days;
    }

    /**
     * Set the days property: The number of days to retain an untagged manifest after which it gets purged.
     * 
     * @param days the days value to set.
     * @return the RetentionPolicy object itself.
     */
    public RetentionPolicy withDays(Integer days) {
        this.days = days;
        return this;
    }

    /**
     * Get the lastUpdatedTime property: The timestamp when the policy was last updated.
     * 
     * @return the lastUpdatedTime value.
     */
    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    /**
     * Get the status property: The value that indicates whether the policy is enabled or not.
     * 
     * @return the status value.
     */
    public PolicyStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The value that indicates whether the policy is enabled or not.
     * 
     * @param status the status value to set.
     * @return the RetentionPolicy object itself.
     */
    public RetentionPolicy withStatus(PolicyStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("days", this.days);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RetentionPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RetentionPolicy if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RetentionPolicy.
     */
    public static RetentionPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RetentionPolicy deserializedRetentionPolicy = new RetentionPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("days".equals(fieldName)) {
                    deserializedRetentionPolicy.days = reader.getNullable(JsonReader::getInt);
                } else if ("lastUpdatedTime".equals(fieldName)) {
                    deserializedRetentionPolicy.lastUpdatedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("status".equals(fieldName)) {
                    deserializedRetentionPolicy.status = PolicyStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRetentionPolicy;
        });
    }
}
