// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.ReplicationInner;
import java.io.IOException;
import java.util.List;

/**
 * The result of a request to list replications for a container registry.
 */
@Fluent
public final class ReplicationListResult implements JsonSerializable<ReplicationListResult> {
    /*
     * The list of replications. Since this list may be incomplete, the nextLink field should be used to request the
     * next list of replications.
     */
    private List<ReplicationInner> value;

    /*
     * The URI that can be used to request the next list of replications.
     */
    private String nextLink;

    /**
     * Creates an instance of ReplicationListResult class.
     */
    public ReplicationListResult() {
    }

    /**
     * Get the value property: The list of replications. Since this list may be incomplete, the nextLink field should be
     * used to request the next list of replications.
     * 
     * @return the value value.
     */
    public List<ReplicationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of replications. Since this list may be incomplete, the nextLink field should be
     * used to request the next list of replications.
     * 
     * @param value the value value to set.
     * @return the ReplicationListResult object itself.
     */
    public ReplicationListResult withValue(List<ReplicationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI that can be used to request the next list of replications.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI that can be used to request the next list of replications.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ReplicationListResult object itself.
     */
    public ReplicationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReplicationListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReplicationListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ReplicationListResult.
     */
    public static ReplicationListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReplicationListResult deserializedReplicationListResult = new ReplicationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ReplicationInner> value = reader.readArray(reader1 -> ReplicationInner.fromJson(reader1));
                    deserializedReplicationListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedReplicationListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReplicationListResult;
        });
    }
}
