// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The display information for a container registry operation.
 */
@Fluent
public final class OperationDisplayDefinition implements JsonSerializable<OperationDisplayDefinition> {
    /*
     * The resource provider name: Microsoft.ContainerRegistry.
     */
    private String provider;

    /*
     * The resource on which the operation is performed.
     */
    private String resource;

    /*
     * The operation that users can perform.
     */
    private String operation;

    /*
     * The description for the operation.
     */
    private String description;

    /**
     * Creates an instance of OperationDisplayDefinition class.
     */
    public OperationDisplayDefinition() {
    }

    /**
     * Get the provider property: The resource provider name: Microsoft.ContainerRegistry.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.provider;
    }

    /**
     * Set the provider property: The resource provider name: Microsoft.ContainerRegistry.
     * 
     * @param provider the provider value to set.
     * @return the OperationDisplayDefinition object itself.
     */
    public OperationDisplayDefinition withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    /**
     * Get the resource property: The resource on which the operation is performed.
     * 
     * @return the resource value.
     */
    public String resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The resource on which the operation is performed.
     * 
     * @param resource the resource value to set.
     * @return the OperationDisplayDefinition object itself.
     */
    public OperationDisplayDefinition withResource(String resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the operation property: The operation that users can perform.
     * 
     * @return the operation value.
     */
    public String operation() {
        return this.operation;
    }

    /**
     * Set the operation property: The operation that users can perform.
     * 
     * @param operation the operation value to set.
     * @return the OperationDisplayDefinition object itself.
     */
    public OperationDisplayDefinition withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    /**
     * Get the description property: The description for the operation.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description for the operation.
     * 
     * @param description the description value to set.
     * @return the OperationDisplayDefinition object itself.
     */
    public OperationDisplayDefinition withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeStringField("resource", this.resource);
        jsonWriter.writeStringField("operation", this.operation);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationDisplayDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationDisplayDefinition if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationDisplayDefinition.
     */
    public static OperationDisplayDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationDisplayDefinition deserializedOperationDisplayDefinition = new OperationDisplayDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provider".equals(fieldName)) {
                    deserializedOperationDisplayDefinition.provider = reader.getString();
                } else if ("resource".equals(fieldName)) {
                    deserializedOperationDisplayDefinition.resource = reader.getString();
                } else if ("operation".equals(fieldName)) {
                    deserializedOperationDisplayDefinition.operation = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedOperationDisplayDefinition.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationDisplayDefinition;
        });
    }
}
