// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The verbosity of logs persisted on the connected registry.
 */
public final class LogLevel extends ExpandableStringEnum<LogLevel> {
    /**
     * Static value Debug for LogLevel.
     */
    public static final LogLevel DEBUG = fromString("Debug");

    /**
     * Static value Information for LogLevel.
     */
    public static final LogLevel INFORMATION = fromString("Information");

    /**
     * Static value Warning for LogLevel.
     */
    public static final LogLevel WARNING = fromString("Warning");

    /**
     * Static value Error for LogLevel.
     */
    public static final LogLevel ERROR = fromString("Error");

    /**
     * Static value None for LogLevel.
     */
    public static final LogLevel NONE = fromString("None");

    /**
     * Creates a new instance of LogLevel value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LogLevel() {
    }

    /**
     * Creates or finds a LogLevel from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding LogLevel.
     */
    public static LogLevel fromString(String name) {
        return fromString(name, LogLevel.class);
    }

    /**
     * Gets known LogLevel values.
     * 
     * @return known LogLevel values.
     */
    public static Collection<LogLevel> values() {
        return values(LogLevel.class);
    }
}
