// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ImportSourceCredentials model.
 */
@Fluent
public final class ImportSourceCredentials implements JsonSerializable<ImportSourceCredentials> {
    /*
     * The username to authenticate with the source registry.
     */
    private String username;

    /*
     * The password used to authenticate with the source registry.
     */
    private String password;

    /**
     * Creates an instance of ImportSourceCredentials class.
     */
    public ImportSourceCredentials() {
    }

    /**
     * Get the username property: The username to authenticate with the source registry.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: The username to authenticate with the source registry.
     * 
     * @param username the username value to set.
     * @return the ImportSourceCredentials object itself.
     */
    public ImportSourceCredentials withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: The password used to authenticate with the source registry.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: The password used to authenticate with the source registry.
     * 
     * @param password the password value to set.
     * @return the ImportSourceCredentials object itself.
     */
    public ImportSourceCredentials withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (password() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property password in model ImportSourceCredentials"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ImportSourceCredentials.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("username", this.username);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImportSourceCredentials from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImportSourceCredentials if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ImportSourceCredentials.
     */
    public static ImportSourceCredentials fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImportSourceCredentials deserializedImportSourceCredentials = new ImportSourceCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("password".equals(fieldName)) {
                    deserializedImportSourceCredentials.password = reader.getString();
                } else if ("username".equals(fieldName)) {
                    deserializedImportSourceCredentials.username = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedImportSourceCredentials;
        });
    }
}
