// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The parameters used to generate credentials for a specified token or user of a container registry.
 */
@Fluent
public final class GenerateCredentialsParameters implements JsonSerializable<GenerateCredentialsParameters> {
    /*
     * The resource ID of the token for which credentials have to be generated.
     */
    private String tokenId;

    /*
     * The expiry date of the generated credentials after which the credentials become invalid.
     */
    private OffsetDateTime expiry;

    /*
     * Specifies name of the password which should be regenerated if any -- password1 or password2.
     */
    private TokenPasswordName name;

    /**
     * Creates an instance of GenerateCredentialsParameters class.
     */
    public GenerateCredentialsParameters() {
    }

    /**
     * Get the tokenId property: The resource ID of the token for which credentials have to be generated.
     * 
     * @return the tokenId value.
     */
    public String tokenId() {
        return this.tokenId;
    }

    /**
     * Set the tokenId property: The resource ID of the token for which credentials have to be generated.
     * 
     * @param tokenId the tokenId value to set.
     * @return the GenerateCredentialsParameters object itself.
     */
    public GenerateCredentialsParameters withTokenId(String tokenId) {
        this.tokenId = tokenId;
        return this;
    }

    /**
     * Get the expiry property: The expiry date of the generated credentials after which the credentials become invalid.
     * 
     * @return the expiry value.
     */
    public OffsetDateTime expiry() {
        return this.expiry;
    }

    /**
     * Set the expiry property: The expiry date of the generated credentials after which the credentials become invalid.
     * 
     * @param expiry the expiry value to set.
     * @return the GenerateCredentialsParameters object itself.
     */
    public GenerateCredentialsParameters withExpiry(OffsetDateTime expiry) {
        this.expiry = expiry;
        return this;
    }

    /**
     * Get the name property: Specifies name of the password which should be regenerated if any -- password1 or
     * password2.
     * 
     * @return the name value.
     */
    public TokenPasswordName name() {
        return this.name;
    }

    /**
     * Set the name property: Specifies name of the password which should be regenerated if any -- password1 or
     * password2.
     * 
     * @param name the name value to set.
     * @return the GenerateCredentialsParameters object itself.
     */
    public GenerateCredentialsParameters withName(TokenPasswordName name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tokenId", this.tokenId);
        jsonWriter.writeStringField("expiry",
            this.expiry == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiry));
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GenerateCredentialsParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GenerateCredentialsParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GenerateCredentialsParameters.
     */
    public static GenerateCredentialsParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GenerateCredentialsParameters deserializedGenerateCredentialsParameters
                = new GenerateCredentialsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tokenId".equals(fieldName)) {
                    deserializedGenerateCredentialsParameters.tokenId = reader.getString();
                } else if ("expiry".equals(fieldName)) {
                    deserializedGenerateCredentialsParameters.expiry = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("name".equals(fieldName)) {
                    deserializedGenerateCredentialsParameters.name = TokenPasswordName.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGenerateCredentialsParameters;
        });
    }
}
