// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The garbage collection properties of the connected registry.
 */
@Fluent
public final class GarbageCollectionProperties implements JsonSerializable<GarbageCollectionProperties> {
    /*
     * Indicates whether garbage collection is enabled for the connected registry.
     */
    private Boolean enabled;

    /*
     * The cron expression indicating the schedule that the connected registry will run garbage collection.
     */
    private String schedule;

    /**
     * Creates an instance of GarbageCollectionProperties class.
     */
    public GarbageCollectionProperties() {
    }

    /**
     * Get the enabled property: Indicates whether garbage collection is enabled for the connected registry.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates whether garbage collection is enabled for the connected registry.
     * 
     * @param enabled the enabled value to set.
     * @return the GarbageCollectionProperties object itself.
     */
    public GarbageCollectionProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the schedule property: The cron expression indicating the schedule that the connected registry will run
     * garbage collection.
     * 
     * @return the schedule value.
     */
    public String schedule() {
        return this.schedule;
    }

    /**
     * Set the schedule property: The cron expression indicating the schedule that the connected registry will run
     * garbage collection.
     * 
     * @param schedule the schedule value to set.
     * @return the GarbageCollectionProperties object itself.
     */
    public GarbageCollectionProperties withSchedule(String schedule) {
        this.schedule = schedule;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("schedule", this.schedule);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GarbageCollectionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GarbageCollectionProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GarbageCollectionProperties.
     */
    public static GarbageCollectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GarbageCollectionProperties deserializedGarbageCollectionProperties = new GarbageCollectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedGarbageCollectionProperties.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("schedule".equals(fieldName)) {
                    deserializedGarbageCollectionProperties.schedule = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGarbageCollectionProperties;
        });
    }
}
