// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The properties of a encoded task step.
 */
@Fluent
public final class EncodedTaskStep extends TaskStepProperties {
    /*
     * The type of the step.
     */
    private StepType type = StepType.ENCODED_TASK;

    /*
     * Base64 encoded value of the template/definition file content.
     */
    private String encodedTaskContent;

    /*
     * Base64 encoded value of the parameters/values file content.
     */
    private String encodedValuesContent;

    /*
     * The collection of overridable values that can be passed when running a task.
     */
    private List<SetValue> values;

    /**
     * Creates an instance of EncodedTaskStep class.
     */
    public EncodedTaskStep() {
    }

    /**
     * Get the type property: The type of the step.
     * 
     * @return the type value.
     */
    @Override
    public StepType type() {
        return this.type;
    }

    /**
     * Get the encodedTaskContent property: Base64 encoded value of the template/definition file content.
     * 
     * @return the encodedTaskContent value.
     */
    public String encodedTaskContent() {
        return this.encodedTaskContent;
    }

    /**
     * Set the encodedTaskContent property: Base64 encoded value of the template/definition file content.
     * 
     * @param encodedTaskContent the encodedTaskContent value to set.
     * @return the EncodedTaskStep object itself.
     */
    public EncodedTaskStep withEncodedTaskContent(String encodedTaskContent) {
        this.encodedTaskContent = encodedTaskContent;
        return this;
    }

    /**
     * Get the encodedValuesContent property: Base64 encoded value of the parameters/values file content.
     * 
     * @return the encodedValuesContent value.
     */
    public String encodedValuesContent() {
        return this.encodedValuesContent;
    }

    /**
     * Set the encodedValuesContent property: Base64 encoded value of the parameters/values file content.
     * 
     * @param encodedValuesContent the encodedValuesContent value to set.
     * @return the EncodedTaskStep object itself.
     */
    public EncodedTaskStep withEncodedValuesContent(String encodedValuesContent) {
        this.encodedValuesContent = encodedValuesContent;
        return this;
    }

    /**
     * Get the values property: The collection of overridable values that can be passed when running a task.
     * 
     * @return the values value.
     */
    public List<SetValue> values() {
        return this.values;
    }

    /**
     * Set the values property: The collection of overridable values that can be passed when running a task.
     * 
     * @param values the values value to set.
     * @return the EncodedTaskStep object itself.
     */
    public EncodedTaskStep withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EncodedTaskStep withContextPath(String contextPath) {
        super.withContextPath(contextPath);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EncodedTaskStep withContextAccessToken(String contextAccessToken) {
        super.withContextAccessToken(contextAccessToken);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (encodedTaskContent() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property encodedTaskContent in model EncodedTaskStep"));
        }
        if (values() != null) {
            values().forEach(e -> e.validate());
        }
        if (baseImageDependencies() != null) {
            baseImageDependencies().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(EncodedTaskStep.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contextPath", contextPath());
        jsonWriter.writeStringField("contextAccessToken", contextAccessToken());
        jsonWriter.writeStringField("encodedTaskContent", this.encodedTaskContent);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("encodedValuesContent", this.encodedValuesContent);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EncodedTaskStep from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EncodedTaskStep if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EncodedTaskStep.
     */
    public static EncodedTaskStep fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncodedTaskStep deserializedEncodedTaskStep = new EncodedTaskStep();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("baseImageDependencies".equals(fieldName)) {
                    List<BaseImageDependency> baseImageDependencies
                        = reader.readArray(reader1 -> BaseImageDependency.fromJson(reader1));
                    deserializedEncodedTaskStep.withBaseImageDependencies(baseImageDependencies);
                } else if ("contextPath".equals(fieldName)) {
                    deserializedEncodedTaskStep.withContextPath(reader.getString());
                } else if ("contextAccessToken".equals(fieldName)) {
                    deserializedEncodedTaskStep.withContextAccessToken(reader.getString());
                } else if ("encodedTaskContent".equals(fieldName)) {
                    deserializedEncodedTaskStep.encodedTaskContent = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedEncodedTaskStep.type = StepType.fromString(reader.getString());
                } else if ("encodedValuesContent".equals(fieldName)) {
                    deserializedEncodedTaskStep.encodedValuesContent = reader.getString();
                } else if ("values".equals(fieldName)) {
                    List<SetValue> values = reader.readArray(reader1 -> SetValue.fromJson(reader1));
                    deserializedEncodedTaskStep.values = values;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncodedTaskStep;
        });
    }
}
