// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties of a run argument.
 */
@Fluent
public final class Argument implements JsonSerializable<Argument> {
    /*
     * The name of the argument.
     */
    private String name;

    /*
     * The value of the argument.
     */
    private String value;

    /*
     * Flag to indicate whether the argument represents a secret and want to be removed from build logs.
     */
    private Boolean isSecret;

    /**
     * Creates an instance of Argument class.
     */
    public Argument() {
    }

    /**
     * Get the name property: The name of the argument.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the argument.
     * 
     * @param name the name value to set.
     * @return the Argument object itself.
     */
    public Argument withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The value of the argument.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the argument.
     * 
     * @param value the value value to set.
     * @return the Argument object itself.
     */
    public Argument withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the isSecret property: Flag to indicate whether the argument represents a secret and want to be removed from
     * build logs.
     * 
     * @return the isSecret value.
     */
    public Boolean isSecret() {
        return this.isSecret;
    }

    /**
     * Set the isSecret property: Flag to indicate whether the argument represents a secret and want to be removed from
     * build logs.
     * 
     * @param isSecret the isSecret value to set.
     * @return the Argument object itself.
     */
    public Argument withIsSecret(Boolean isSecret) {
        this.isSecret = isSecret;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model Argument"));
        }
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model Argument"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(Argument.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeBooleanField("isSecret", this.isSecret);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Argument from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Argument if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Argument.
     */
    public static Argument fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Argument deserializedArgument = new Argument();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedArgument.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedArgument.value = reader.getString();
                } else if ("isSecret".equals(fieldName)) {
                    deserializedArgument.isSecret = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedArgument;
        });
    }
}
