// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties that determine the run agent configuration.
 */
@Fluent
public final class AgentProperties implements JsonSerializable<AgentProperties> {
    /*
     * The CPU configuration in terms of number of cores required for the run.
     */
    private Integer cpu;

    /**
     * Creates an instance of AgentProperties class.
     */
    public AgentProperties() {
    }

    /**
     * Get the cpu property: The CPU configuration in terms of number of cores required for the run.
     * 
     * @return the cpu value.
     */
    public Integer cpu() {
        return this.cpu;
    }

    /**
     * Set the cpu property: The CPU configuration in terms of number of cores required for the run.
     * 
     * @param cpu the cpu value to set.
     * @return the AgentProperties object itself.
     */
    public AgentProperties withCpu(Integer cpu) {
        this.cpu = cpu;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("cpu", this.cpu);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AgentProperties.
     */
    public static AgentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentProperties deserializedAgentProperties = new AgentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cpu".equals(fieldName)) {
                    deserializedAgentProperties.cpu = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentProperties;
        });
    }
}
