// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.TokenCredentialsProperties;
import com.azure.resourcemanager.containerregistry.models.TokenStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The properties of a token.
 */
@Fluent
public final class TokenProperties implements JsonSerializable<TokenProperties> {
    /*
     * The creation date of scope map.
     */
    private OffsetDateTime creationDate;

    /*
     * Provisioning state of the resource.
     */
    private ProvisioningState provisioningState;

    /*
     * The resource ID of the scope map to which the token will be associated with.
     */
    private String scopeMapId;

    /*
     * The credentials that can be used for authenticating the token.
     */
    private TokenCredentialsProperties credentials;

    /*
     * The status of the token example enabled or disabled.
     */
    private TokenStatus status;

    /**
     * Creates an instance of TokenProperties class.
     */
    public TokenProperties() {
    }

    /**
     * Get the creationDate property: The creation date of scope map.
     * 
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the scopeMapId property: The resource ID of the scope map to which the token will be associated with.
     * 
     * @return the scopeMapId value.
     */
    public String scopeMapId() {
        return this.scopeMapId;
    }

    /**
     * Set the scopeMapId property: The resource ID of the scope map to which the token will be associated with.
     * 
     * @param scopeMapId the scopeMapId value to set.
     * @return the TokenProperties object itself.
     */
    public TokenProperties withScopeMapId(String scopeMapId) {
        this.scopeMapId = scopeMapId;
        return this;
    }

    /**
     * Get the credentials property: The credentials that can be used for authenticating the token.
     * 
     * @return the credentials value.
     */
    public TokenCredentialsProperties credentials() {
        return this.credentials;
    }

    /**
     * Set the credentials property: The credentials that can be used for authenticating the token.
     * 
     * @param credentials the credentials value to set.
     * @return the TokenProperties object itself.
     */
    public TokenProperties withCredentials(TokenCredentialsProperties credentials) {
        this.credentials = credentials;
        return this;
    }

    /**
     * Get the status property: The status of the token example enabled or disabled.
     * 
     * @return the status value.
     */
    public TokenStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The status of the token example enabled or disabled.
     * 
     * @param status the status value to set.
     * @return the TokenProperties object itself.
     */
    public TokenProperties withStatus(TokenStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (credentials() != null) {
            credentials().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scopeMapId", this.scopeMapId);
        jsonWriter.writeJsonField("credentials", this.credentials);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TokenProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TokenProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TokenProperties.
     */
    public static TokenProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TokenProperties deserializedTokenProperties = new TokenProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("creationDate".equals(fieldName)) {
                    deserializedTokenProperties.creationDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedTokenProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                } else if ("scopeMapId".equals(fieldName)) {
                    deserializedTokenProperties.scopeMapId = reader.getString();
                } else if ("credentials".equals(fieldName)) {
                    deserializedTokenProperties.credentials = TokenCredentialsProperties.fromJson(reader);
                } else if ("status".equals(fieldName)) {
                    deserializedTokenProperties.status = TokenStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTokenProperties;
        });
    }
}
