// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * The properties of a scope map.
 */
@Fluent
public final class ScopeMapProperties implements JsonSerializable<ScopeMapProperties> {
    /*
     * The user friendly description of the scope map.
     */
    private String description;

    /*
     * The type of the scope map. E.g. BuildIn scope map.
     */
    private String type;

    /*
     * The creation date of scope map.
     */
    private OffsetDateTime creationDate;

    /*
     * Provisioning state of the resource.
     */
    private ProvisioningState provisioningState;

    /*
     * The list of scoped permissions for registry artifacts.
     * E.g. repositories/repository-name/content/read,
     * repositories/repository-name/metadata/write
     */
    private List<String> actions;

    /**
     * Creates an instance of ScopeMapProperties class.
     */
    public ScopeMapProperties() {
    }

    /**
     * Get the description property: The user friendly description of the scope map.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The user friendly description of the scope map.
     * 
     * @param description the description value to set.
     * @return the ScopeMapProperties object itself.
     */
    public ScopeMapProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the type property: The type of the scope map. E.g. BuildIn scope map.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the creationDate property: The creation date of scope map.
     * 
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the actions property: The list of scoped permissions for registry artifacts.
     * E.g. repositories/repository-name/content/read,
     * repositories/repository-name/metadata/write.
     * 
     * @return the actions value.
     */
    public List<String> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: The list of scoped permissions for registry artifacts.
     * E.g. repositories/repository-name/content/read,
     * repositories/repository-name/metadata/write.
     * 
     * @param actions the actions value to set.
     * @return the ScopeMapProperties object itself.
     */
    public ScopeMapProperties withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (actions() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property actions in model ScopeMapProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ScopeMapProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScopeMapProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScopeMapProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ScopeMapProperties.
     */
    public static ScopeMapProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScopeMapProperties deserializedScopeMapProperties = new ScopeMapProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("actions".equals(fieldName)) {
                    List<String> actions = reader.readArray(reader1 -> reader1.getString());
                    deserializedScopeMapProperties.actions = actions;
                } else if ("description".equals(fieldName)) {
                    deserializedScopeMapProperties.description = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedScopeMapProperties.type = reader.getString();
                } else if ("creationDate".equals(fieldName)) {
                    deserializedScopeMapProperties.creationDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedScopeMapProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScopeMapProperties;
        });
    }
}
