// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.AuthCredential;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * The properties of a credential set resource.
 */
@Fluent
public final class CredentialSetProperties implements JsonSerializable<CredentialSetProperties> {
    /*
     * The credentials are stored for this upstream or login server.
     */
    private String loginServer;

    /*
     * List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     */
    private List<AuthCredential> authCredentials;

    /*
     * The creation date of credential store resource.
     */
    private OffsetDateTime creationDate;

    /*
     * Provisioning state of the resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of CredentialSetProperties class.
     */
    public CredentialSetProperties() {
    }

    /**
     * Get the loginServer property: The credentials are stored for this upstream or login server.
     * 
     * @return the loginServer value.
     */
    public String loginServer() {
        return this.loginServer;
    }

    /**
     * Set the loginServer property: The credentials are stored for this upstream or login server.
     * 
     * @param loginServer the loginServer value to set.
     * @return the CredentialSetProperties object itself.
     */
    public CredentialSetProperties withLoginServer(String loginServer) {
        this.loginServer = loginServer;
        return this;
    }

    /**
     * Get the authCredentials property: List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     * 
     * @return the authCredentials value.
     */
    public List<AuthCredential> authCredentials() {
        return this.authCredentials;
    }

    /**
     * Set the authCredentials property: List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     * 
     * @param authCredentials the authCredentials value to set.
     * @return the CredentialSetProperties object itself.
     */
    public CredentialSetProperties withAuthCredentials(List<AuthCredential> authCredentials) {
        this.authCredentials = authCredentials;
        return this;
    }

    /**
     * Get the creationDate property: The creation date of credential store resource.
     * 
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (authCredentials() != null) {
            authCredentials().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("loginServer", this.loginServer);
        jsonWriter.writeArrayField("authCredentials", this.authCredentials,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CredentialSetProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CredentialSetProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CredentialSetProperties.
     */
    public static CredentialSetProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CredentialSetProperties deserializedCredentialSetProperties = new CredentialSetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("loginServer".equals(fieldName)) {
                    deserializedCredentialSetProperties.loginServer = reader.getString();
                } else if ("authCredentials".equals(fieldName)) {
                    List<AuthCredential> authCredentials
                        = reader.readArray(reader1 -> AuthCredential.fromJson(reader1));
                    deserializedCredentialSetProperties.authCredentials = authCredentials;
                } else if ("creationDate".equals(fieldName)) {
                    deserializedCredentialSetProperties.creationDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedCredentialSetProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCredentialSetProperties;
        });
    }
}
