// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.AuthCredential;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * An object that represents a credential set resource for a container registry.
 */
@Fluent
public final class CredentialSetInner extends ProxyResource {
    /*
     * Identities associated with the resource. This is used to access the KeyVault secrets.
     */
    private IdentityProperties identity;

    /*
     * The properties of the credential set.
     */
    private CredentialSetProperties innerProperties;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of CredentialSetInner class.
     */
    public CredentialSetInner() {
    }

    /**
     * Get the identity property: Identities associated with the resource. This is used to access the KeyVault secrets.
     * 
     * @return the identity value.
     */
    public IdentityProperties identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Identities associated with the resource. This is used to access the KeyVault secrets.
     * 
     * @param identity the identity value to set.
     * @return the CredentialSetInner object itself.
     */
    public CredentialSetInner withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the innerProperties property: The properties of the credential set.
     * 
     * @return the innerProperties value.
     */
    private CredentialSetProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the loginServer property: The credentials are stored for this upstream or login server.
     * 
     * @return the loginServer value.
     */
    public String loginServer() {
        return this.innerProperties() == null ? null : this.innerProperties().loginServer();
    }

    /**
     * Set the loginServer property: The credentials are stored for this upstream or login server.
     * 
     * @param loginServer the loginServer value to set.
     * @return the CredentialSetInner object itself.
     */
    public CredentialSetInner withLoginServer(String loginServer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CredentialSetProperties();
        }
        this.innerProperties().withLoginServer(loginServer);
        return this;
    }

    /**
     * Get the authCredentials property: List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     * 
     * @return the authCredentials value.
     */
    public List<AuthCredential> authCredentials() {
        return this.innerProperties() == null ? null : this.innerProperties().authCredentials();
    }

    /**
     * Set the authCredentials property: List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     * 
     * @param authCredentials the authCredentials value to set.
     * @return the CredentialSetInner object itself.
     */
    public CredentialSetInner withAuthCredentials(List<AuthCredential> authCredentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CredentialSetProperties();
        }
        this.innerProperties().withAuthCredentials(authCredentials);
        return this;
    }

    /**
     * Get the creationDate property: The creation date of credential store resource.
     * 
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CredentialSetInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CredentialSetInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CredentialSetInner.
     */
    public static CredentialSetInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CredentialSetInner deserializedCredentialSetInner = new CredentialSetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCredentialSetInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedCredentialSetInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedCredentialSetInner.type = reader.getString();
                } else if ("identity".equals(fieldName)) {
                    deserializedCredentialSetInner.identity = IdentityProperties.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedCredentialSetInner.innerProperties = CredentialSetProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedCredentialSetInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCredentialSetInner;
        });
    }
}
