// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The configuration of service URI and custom headers for the webhook.
 */
@Fluent
public final class CallbackConfigInner implements JsonSerializable<CallbackConfigInner> {
    /*
     * The service URI for the webhook to post notifications.
     */
    private String serviceUri;

    /*
     * Custom headers that will be added to the webhook notifications.
     */
    private Map<String, String> customHeaders;

    /**
     * Creates an instance of CallbackConfigInner class.
     */
    public CallbackConfigInner() {
    }

    /**
     * Get the serviceUri property: The service URI for the webhook to post notifications.
     * 
     * @return the serviceUri value.
     */
    public String serviceUri() {
        return this.serviceUri;
    }

    /**
     * Set the serviceUri property: The service URI for the webhook to post notifications.
     * 
     * @param serviceUri the serviceUri value to set.
     * @return the CallbackConfigInner object itself.
     */
    public CallbackConfigInner withServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
        return this;
    }

    /**
     * Get the customHeaders property: Custom headers that will be added to the webhook notifications.
     * 
     * @return the customHeaders value.
     */
    public Map<String, String> customHeaders() {
        return this.customHeaders;
    }

    /**
     * Set the customHeaders property: Custom headers that will be added to the webhook notifications.
     * 
     * @param customHeaders the customHeaders value to set.
     * @return the CallbackConfigInner object itself.
     */
    public CallbackConfigInner withCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (serviceUri() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property serviceUri in model CallbackConfigInner"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CallbackConfigInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceUri", this.serviceUri);
        jsonWriter.writeMapField("customHeaders", this.customHeaders, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CallbackConfigInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CallbackConfigInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CallbackConfigInner.
     */
    public static CallbackConfigInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CallbackConfigInner deserializedCallbackConfigInner = new CallbackConfigInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceUri".equals(fieldName)) {
                    deserializedCallbackConfigInner.serviceUri = reader.getString();
                } else if ("customHeaders".equals(fieldName)) {
                    Map<String, String> customHeaders = reader.readMap(reader1 -> reader1.getString());
                    deserializedCallbackConfigInner.customHeaders = customHeaders;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCallbackConfigInner;
        });
    }
}
