// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The parameters for updating cache rule properties.
 */
@Fluent
public final class CacheRuleUpdateProperties implements JsonSerializable<CacheRuleUpdateProperties> {
    /*
     * The ARM resource ID of the credential store which is associated with the Cache rule.
     */
    private String credentialSetResourceId;

    /**
     * Creates an instance of CacheRuleUpdateProperties class.
     */
    public CacheRuleUpdateProperties() {
    }

    /**
     * Get the credentialSetResourceId property: The ARM resource ID of the credential store which is associated with
     * the Cache rule.
     * 
     * @return the credentialSetResourceId value.
     */
    public String credentialSetResourceId() {
        return this.credentialSetResourceId;
    }

    /**
     * Set the credentialSetResourceId property: The ARM resource ID of the credential store which is associated with
     * the Cache rule.
     * 
     * @param credentialSetResourceId the credentialSetResourceId value to set.
     * @return the CacheRuleUpdateProperties object itself.
     */
    public CacheRuleUpdateProperties withCredentialSetResourceId(String credentialSetResourceId) {
        this.credentialSetResourceId = credentialSetResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("credentialSetResourceId", this.credentialSetResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CacheRuleUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CacheRuleUpdateProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CacheRuleUpdateProperties.
     */
    public static CacheRuleUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CacheRuleUpdateProperties deserializedCacheRuleUpdateProperties = new CacheRuleUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("credentialSetResourceId".equals(fieldName)) {
                    deserializedCacheRuleUpdateProperties.credentialSetResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCacheRuleUpdateProperties;
        });
    }
}
