/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.azure.resourcemanager.containerregistry.models.Credentials;
import com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.azure.resourcemanager.containerregistry.models.RunRequest;
import com.azure.resourcemanager.containerregistry.models.SetValue;
import java.io.IOException;
import java.util.List;

public final class FileTaskRunRequest
extends RunRequest {
    private String type = "FileTaskRunRequest";
    private String taskFilePath;
    private String valuesFilePath;
    private List<SetValue> values;
    private Integer timeout;
    private PlatformProperties platform;
    private AgentProperties agentConfiguration;
    private String sourceLocation;
    private Credentials credentials;
    private static final ClientLogger LOGGER = new ClientLogger(FileTaskRunRequest.class);

    @Override
    public String type() {
        return this.type;
    }

    public String taskFilePath() {
        return this.taskFilePath;
    }

    public FileTaskRunRequest withTaskFilePath(String taskFilePath) {
        this.taskFilePath = taskFilePath;
        return this;
    }

    public String valuesFilePath() {
        return this.valuesFilePath;
    }

    public FileTaskRunRequest withValuesFilePath(String valuesFilePath) {
        this.valuesFilePath = valuesFilePath;
        return this;
    }

    public List<SetValue> values() {
        return this.values;
    }

    public FileTaskRunRequest withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public FileTaskRunRequest withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public PlatformProperties platform() {
        return this.platform;
    }

    public FileTaskRunRequest withPlatform(PlatformProperties platform) {
        this.platform = platform;
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.agentConfiguration;
    }

    public FileTaskRunRequest withAgentConfiguration(AgentProperties agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public String sourceLocation() {
        return this.sourceLocation;
    }

    public FileTaskRunRequest withSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
        return this;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public FileTaskRunRequest withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Override
    public FileTaskRunRequest withIsArchiveEnabled(Boolean isArchiveEnabled) {
        super.withIsArchiveEnabled(isArchiveEnabled);
        return this;
    }

    @Override
    public FileTaskRunRequest withAgentPoolName(String agentPoolName) {
        super.withAgentPoolName(agentPoolName);
        return this;
    }

    @Override
    public FileTaskRunRequest withLogTemplate(String logTemplate) {
        super.withLogTemplate(logTemplate);
        return this;
    }

    @Override
    public void validate() {
        if (this.taskFilePath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property taskFilePath in model FileTaskRunRequest"));
        }
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
        if (this.platform() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property platform in model FileTaskRunRequest"));
        }
        this.platform().validate();
        if (this.agentConfiguration() != null) {
            this.agentConfiguration().validate();
        }
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isArchiveEnabled", this.isArchiveEnabled());
        jsonWriter.writeStringField("agentPoolName", this.agentPoolName());
        jsonWriter.writeStringField("logTemplate", this.logTemplate());
        jsonWriter.writeStringField("taskFilePath", this.taskFilePath);
        jsonWriter.writeJsonField("platform", (JsonSerializable)this.platform);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("valuesFilePath", this.valuesFilePath);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("timeout", (Number)this.timeout);
        jsonWriter.writeJsonField("agentConfiguration", (JsonSerializable)this.agentConfiguration);
        jsonWriter.writeStringField("sourceLocation", this.sourceLocation);
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials);
        return jsonWriter.writeEndObject();
    }

    public static FileTaskRunRequest fromJson(JsonReader jsonReader) throws IOException {
        return (FileTaskRunRequest)jsonReader.readObject(reader -> {
            FileTaskRunRequest deserializedFileTaskRunRequest = new FileTaskRunRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isArchiveEnabled".equals(fieldName)) {
                    deserializedFileTaskRunRequest.withIsArchiveEnabled((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("agentPoolName".equals(fieldName)) {
                    deserializedFileTaskRunRequest.withAgentPoolName(reader.getString());
                    continue;
                }
                if ("logTemplate".equals(fieldName)) {
                    deserializedFileTaskRunRequest.withLogTemplate(reader.getString());
                    continue;
                }
                if ("taskFilePath".equals(fieldName)) {
                    deserializedFileTaskRunRequest.taskFilePath = reader.getString();
                    continue;
                }
                if ("platform".equals(fieldName)) {
                    deserializedFileTaskRunRequest.platform = PlatformProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFileTaskRunRequest.type = reader.getString();
                    continue;
                }
                if ("valuesFilePath".equals(fieldName)) {
                    deserializedFileTaskRunRequest.valuesFilePath = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedFileTaskRunRequest.values = values = reader.readArray(reader1 -> SetValue.fromJson(reader1));
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedFileTaskRunRequest.timeout = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("agentConfiguration".equals(fieldName)) {
                    deserializedFileTaskRunRequest.agentConfiguration = AgentProperties.fromJson(reader);
                    continue;
                }
                if ("sourceLocation".equals(fieldName)) {
                    deserializedFileTaskRunRequest.sourceLocation = reader.getString();
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    deserializedFileTaskRunRequest.credentials = Credentials.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileTaskRunRequest;
        });
    }
}

