// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Indicates whether HTTPS is enabled for the login server.
 */
public final class TlsStatus extends ExpandableStringEnum<TlsStatus> {
    /**
     * Static value Enabled for TlsStatus.
     */
    public static final TlsStatus ENABLED = fromString("Enabled");

    /**
     * Static value Disabled for TlsStatus.
     */
    public static final TlsStatus DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of TlsStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public TlsStatus() {
    }

    /**
     * Creates or finds a TlsStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding TlsStatus.
     */
    public static TlsStatus fromString(String name) {
        return fromString(name, TlsStatus.class);
    }

    /**
     * Gets known TlsStatus values.
     * 
     * @return known TlsStatus values.
     */
    public static Collection<TlsStatus> values() {
        return values(TlsStatus.class);
    }
}
