// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The TLS properties of the connected registry login server.
 */
@Immutable
public final class TlsProperties implements JsonSerializable<TlsProperties> {
    /*
     * Indicates whether HTTPS is enabled for the login server.
     */
    private TlsStatus status;

    /*
     * The certificate used to configure HTTPS for the login server.
     */
    private TlsCertificateProperties certificate;

    /**
     * Creates an instance of TlsProperties class.
     */
    public TlsProperties() {
    }

    /**
     * Get the status property: Indicates whether HTTPS is enabled for the login server.
     * 
     * @return the status value.
     */
    public TlsStatus status() {
        return this.status;
    }

    /**
     * Get the certificate property: The certificate used to configure HTTPS for the login server.
     * 
     * @return the certificate value.
     */
    public TlsCertificateProperties certificate() {
        return this.certificate;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (certificate() != null) {
            certificate().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TlsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TlsProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TlsProperties.
     */
    public static TlsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TlsProperties deserializedTlsProperties = new TlsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedTlsProperties.status = TlsStatus.fromString(reader.getString());
                } else if ("certificate".equals(fieldName)) {
                    deserializedTlsProperties.certificate = TlsCertificateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTlsProperties;
        });
    }
}
