// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Base properties for updating any task step.
 */
@Fluent
public class TaskStepUpdateParameters implements JsonSerializable<TaskStepUpdateParameters> {
    /*
     * The type of the step.
     */
    private StepType type = StepType.fromString("TaskStepUpdateParameters");

    /*
     * The URL(absolute or relative) of the source context for the task step.
     */
    private String contextPath;

    /*
     * The token (git PAT or SAS token of storage account blob) associated with the context for a step.
     */
    private String contextAccessToken;

    /**
     * Creates an instance of TaskStepUpdateParameters class.
     */
    public TaskStepUpdateParameters() {
    }

    /**
     * Get the type property: The type of the step.
     * 
     * @return the type value.
     */
    public StepType type() {
        return this.type;
    }

    /**
     * Get the contextPath property: The URL(absolute or relative) of the source context for the task step.
     * 
     * @return the contextPath value.
     */
    public String contextPath() {
        return this.contextPath;
    }

    /**
     * Set the contextPath property: The URL(absolute or relative) of the source context for the task step.
     * 
     * @param contextPath the contextPath value to set.
     * @return the TaskStepUpdateParameters object itself.
     */
    public TaskStepUpdateParameters withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    /**
     * Get the contextAccessToken property: The token (git PAT or SAS token of storage account blob) associated with the
     * context for a step.
     * 
     * @return the contextAccessToken value.
     */
    public String contextAccessToken() {
        return this.contextAccessToken;
    }

    /**
     * Set the contextAccessToken property: The token (git PAT or SAS token of storage account blob) associated with the
     * context for a step.
     * 
     * @param contextAccessToken the contextAccessToken value to set.
     * @return the TaskStepUpdateParameters object itself.
     */
    public TaskStepUpdateParameters withContextAccessToken(String contextAccessToken) {
        this.contextAccessToken = contextAccessToken;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("contextPath", this.contextPath);
        jsonWriter.writeStringField("contextAccessToken", this.contextAccessToken);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TaskStepUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TaskStepUpdateParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TaskStepUpdateParameters.
     */
    public static TaskStepUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("Docker".equals(discriminatorValue)) {
                    return DockerBuildStepUpdateParameters.fromJson(readerToUse.reset());
                } else if ("FileTask".equals(discriminatorValue)) {
                    return FileTaskStepUpdateParameters.fromJson(readerToUse.reset());
                } else if ("EncodedTask".equals(discriminatorValue)) {
                    return EncodedTaskStepUpdateParameters.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static TaskStepUpdateParameters fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TaskStepUpdateParameters deserializedTaskStepUpdateParameters = new TaskStepUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedTaskStepUpdateParameters.type = StepType.fromString(reader.getString());
                } else if ("contextPath".equals(fieldName)) {
                    deserializedTaskStepUpdateParameters.contextPath = reader.getString();
                } else if ("contextAccessToken".equals(fieldName)) {
                    deserializedTaskStepUpdateParameters.contextAccessToken = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTaskStepUpdateParameters;
        });
    }
}
