// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.TaskInner;
import java.io.IOException;
import java.util.List;

/**
 * The collection of tasks.
 */
@Fluent
public final class TaskListResult implements JsonSerializable<TaskListResult> {
    /*
     * The collection value.
     */
    private List<TaskInner> value;

    /*
     * The URI that can be used to request the next set of paged results.
     */
    private String nextLink;

    /**
     * Creates an instance of TaskListResult class.
     */
    public TaskListResult() {
    }

    /**
     * Get the value property: The collection value.
     * 
     * @return the value value.
     */
    public List<TaskInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The collection value.
     * 
     * @param value the value value to set.
     * @return the TaskListResult object itself.
     */
    public TaskListResult withValue(List<TaskInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI that can be used to request the next set of paged results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI that can be used to request the next set of paged results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the TaskListResult object itself.
     */
    public TaskListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TaskListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TaskListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TaskListResult.
     */
    public static TaskListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TaskListResult deserializedTaskListResult = new TaskListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<TaskInner> value = reader.readArray(reader1 -> TaskInner.fromJson(reader1));
                    deserializedTaskListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedTaskListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTaskListResult;
        });
    }
}
