// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The properties for updating a source based trigger.
 */
@Fluent
public final class SourceTriggerUpdateParameters implements JsonSerializable<SourceTriggerUpdateParameters> {
    /*
     * The properties that describes the source(code) for the task.
     */
    private SourceUpdateParameters sourceRepository;

    /*
     * The source event corresponding to the trigger.
     */
    private List<SourceTriggerEvent> sourceTriggerEvents;

    /*
     * The current status of trigger.
     */
    private TriggerStatus status;

    /*
     * The name of the trigger.
     */
    private String name;

    /**
     * Creates an instance of SourceTriggerUpdateParameters class.
     */
    public SourceTriggerUpdateParameters() {
    }

    /**
     * Get the sourceRepository property: The properties that describes the source(code) for the task.
     * 
     * @return the sourceRepository value.
     */
    public SourceUpdateParameters sourceRepository() {
        return this.sourceRepository;
    }

    /**
     * Set the sourceRepository property: The properties that describes the source(code) for the task.
     * 
     * @param sourceRepository the sourceRepository value to set.
     * @return the SourceTriggerUpdateParameters object itself.
     */
    public SourceTriggerUpdateParameters withSourceRepository(SourceUpdateParameters sourceRepository) {
        this.sourceRepository = sourceRepository;
        return this;
    }

    /**
     * Get the sourceTriggerEvents property: The source event corresponding to the trigger.
     * 
     * @return the sourceTriggerEvents value.
     */
    public List<SourceTriggerEvent> sourceTriggerEvents() {
        return this.sourceTriggerEvents;
    }

    /**
     * Set the sourceTriggerEvents property: The source event corresponding to the trigger.
     * 
     * @param sourceTriggerEvents the sourceTriggerEvents value to set.
     * @return the SourceTriggerUpdateParameters object itself.
     */
    public SourceTriggerUpdateParameters withSourceTriggerEvents(List<SourceTriggerEvent> sourceTriggerEvents) {
        this.sourceTriggerEvents = sourceTriggerEvents;
        return this;
    }

    /**
     * Get the status property: The current status of trigger.
     * 
     * @return the status value.
     */
    public TriggerStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The current status of trigger.
     * 
     * @param status the status value to set.
     * @return the SourceTriggerUpdateParameters object itself.
     */
    public SourceTriggerUpdateParameters withStatus(TriggerStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the name property: The name of the trigger.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the trigger.
     * 
     * @param name the name value to set.
     * @return the SourceTriggerUpdateParameters object itself.
     */
    public SourceTriggerUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceRepository() != null) {
            sourceRepository().validate();
        }
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property name in model SourceTriggerUpdateParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SourceTriggerUpdateParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("sourceRepository", this.sourceRepository);
        jsonWriter.writeArrayField("sourceTriggerEvents", this.sourceTriggerEvents,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SourceTriggerUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SourceTriggerUpdateParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SourceTriggerUpdateParameters.
     */
    public static SourceTriggerUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SourceTriggerUpdateParameters deserializedSourceTriggerUpdateParameters
                = new SourceTriggerUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedSourceTriggerUpdateParameters.name = reader.getString();
                } else if ("sourceRepository".equals(fieldName)) {
                    deserializedSourceTriggerUpdateParameters.sourceRepository
                        = SourceUpdateParameters.fromJson(reader);
                } else if ("sourceTriggerEvents".equals(fieldName)) {
                    List<SourceTriggerEvent> sourceTriggerEvents
                        = reader.readArray(reader1 -> SourceTriggerEvent.fromString(reader1.getString()));
                    deserializedSourceTriggerUpdateParameters.sourceTriggerEvents = sourceTriggerEvents;
                } else if ("status".equals(fieldName)) {
                    deserializedSourceTriggerUpdateParameters.status = TriggerStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSourceTriggerUpdateParameters;
        });
    }
}
