// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The login server properties of the connected registry.
 */
@Immutable
public final class LoginServerProperties implements JsonSerializable<LoginServerProperties> {
    /*
     * The host of the connected registry. Can be FQDN or IP.
     */
    private String host;

    /*
     * The TLS properties of the connected registry login server.
     */
    private TlsProperties tls;

    /**
     * Creates an instance of LoginServerProperties class.
     */
    public LoginServerProperties() {
    }

    /**
     * Get the host property: The host of the connected registry. Can be FQDN or IP.
     * 
     * @return the host value.
     */
    public String host() {
        return this.host;
    }

    /**
     * Get the tls property: The TLS properties of the connected registry login server.
     * 
     * @return the tls value.
     */
    public TlsProperties tls() {
        return this.tls;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (tls() != null) {
            tls().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LoginServerProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LoginServerProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LoginServerProperties.
     */
    public static LoginServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LoginServerProperties deserializedLoginServerProperties = new LoginServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("host".equals(fieldName)) {
                    deserializedLoginServerProperties.host = reader.getString();
                } else if ("tls".equals(fieldName)) {
                    deserializedLoginServerProperties.tls = TlsProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLoginServerProperties;
        });
    }
}
