// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ImportSource model.
 */
@Fluent
public final class ImportSource implements JsonSerializable<ImportSource> {
    /*
     * The resource identifier of the source Azure Container Registry.
     */
    private String resourceId;

    /*
     * The address of the source registry (e.g. 'mcr.microsoft.com').
     */
    private String registryUri;

    /*
     * Credentials used when importing from a registry uri.
     */
    private ImportSourceCredentials credentials;

    /*
     * Repository name of the source image.
     * Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     * Specify an image by tag ('hello-world:latest').
     * Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
     */
    private String sourceImage;

    /**
     * Creates an instance of ImportSource class.
     */
    public ImportSource() {
    }

    /**
     * Get the resourceId property: The resource identifier of the source Azure Container Registry.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The resource identifier of the source Azure Container Registry.
     * 
     * @param resourceId the resourceId value to set.
     * @return the ImportSource object itself.
     */
    public ImportSource withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the registryUri property: The address of the source registry (e.g. 'mcr.microsoft.com').
     * 
     * @return the registryUri value.
     */
    public String registryUri() {
        return this.registryUri;
    }

    /**
     * Set the registryUri property: The address of the source registry (e.g. 'mcr.microsoft.com').
     * 
     * @param registryUri the registryUri value to set.
     * @return the ImportSource object itself.
     */
    public ImportSource withRegistryUri(String registryUri) {
        this.registryUri = registryUri;
        return this;
    }

    /**
     * Get the credentials property: Credentials used when importing from a registry uri.
     * 
     * @return the credentials value.
     */
    public ImportSourceCredentials credentials() {
        return this.credentials;
    }

    /**
     * Set the credentials property: Credentials used when importing from a registry uri.
     * 
     * @param credentials the credentials value to set.
     * @return the ImportSource object itself.
     */
    public ImportSource withCredentials(ImportSourceCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    /**
     * Get the sourceImage property: Repository name of the source image.
     * Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     * Specify an image by tag ('hello-world:latest').
     * Specify an image by sha256-based manifest digest ('hello-world&#064;sha256:abc123').
     * 
     * @return the sourceImage value.
     */
    public String sourceImage() {
        return this.sourceImage;
    }

    /**
     * Set the sourceImage property: Repository name of the source image.
     * Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     * Specify an image by tag ('hello-world:latest').
     * Specify an image by sha256-based manifest digest ('hello-world&#064;sha256:abc123').
     * 
     * @param sourceImage the sourceImage value to set.
     * @return the ImportSource object itself.
     */
    public ImportSource withSourceImage(String sourceImage) {
        this.sourceImage = sourceImage;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (credentials() != null) {
            credentials().validate();
        }
        if (sourceImage() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property sourceImage in model ImportSource"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ImportSource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceImage", this.sourceImage);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("registryUri", this.registryUri);
        jsonWriter.writeJsonField("credentials", this.credentials);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImportSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImportSource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ImportSource.
     */
    public static ImportSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImportSource deserializedImportSource = new ImportSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceImage".equals(fieldName)) {
                    deserializedImportSource.sourceImage = reader.getString();
                } else if ("resourceId".equals(fieldName)) {
                    deserializedImportSource.resourceId = reader.getString();
                } else if ("registryUri".equals(fieldName)) {
                    deserializedImportSource.registryUri = reader.getString();
                } else if ("credentials".equals(fieldName)) {
                    deserializedImportSource.credentials = ImportSourceCredentials.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedImportSource;
        });
    }
}
