// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.GarbageCollectionProperties;
import com.azure.resourcemanager.containerregistry.models.LoggingProperties;
import com.azure.resourcemanager.containerregistry.models.SyncUpdateProperties;
import java.io.IOException;
import java.util.List;

/**
 * The parameters for updating token properties.
 */
@Fluent
public final class ConnectedRegistryUpdateProperties implements JsonSerializable<ConnectedRegistryUpdateProperties> {
    /*
     * The sync properties of the connected registry with its parent.
     */
    private SyncUpdateProperties syncProperties;

    /*
     * The logging properties of the connected registry.
     */
    private LoggingProperties logging;

    /*
     * The list of the ACR token resource IDs used to authenticate clients to the connected registry.
     */
    private List<String> clientTokenIds;

    /*
     * The list of notifications subscription information for the connected registry.
     */
    private List<String> notificationsList;

    /*
     * The garbage collection properties of the connected registry.
     */
    private GarbageCollectionProperties garbageCollection;

    /**
     * Creates an instance of ConnectedRegistryUpdateProperties class.
     */
    public ConnectedRegistryUpdateProperties() {
    }

    /**
     * Get the syncProperties property: The sync properties of the connected registry with its parent.
     * 
     * @return the syncProperties value.
     */
    public SyncUpdateProperties syncProperties() {
        return this.syncProperties;
    }

    /**
     * Set the syncProperties property: The sync properties of the connected registry with its parent.
     * 
     * @param syncProperties the syncProperties value to set.
     * @return the ConnectedRegistryUpdateProperties object itself.
     */
    public ConnectedRegistryUpdateProperties withSyncProperties(SyncUpdateProperties syncProperties) {
        this.syncProperties = syncProperties;
        return this;
    }

    /**
     * Get the logging property: The logging properties of the connected registry.
     * 
     * @return the logging value.
     */
    public LoggingProperties logging() {
        return this.logging;
    }

    /**
     * Set the logging property: The logging properties of the connected registry.
     * 
     * @param logging the logging value to set.
     * @return the ConnectedRegistryUpdateProperties object itself.
     */
    public ConnectedRegistryUpdateProperties withLogging(LoggingProperties logging) {
        this.logging = logging;
        return this;
    }

    /**
     * Get the clientTokenIds property: The list of the ACR token resource IDs used to authenticate clients to the
     * connected registry.
     * 
     * @return the clientTokenIds value.
     */
    public List<String> clientTokenIds() {
        return this.clientTokenIds;
    }

    /**
     * Set the clientTokenIds property: The list of the ACR token resource IDs used to authenticate clients to the
     * connected registry.
     * 
     * @param clientTokenIds the clientTokenIds value to set.
     * @return the ConnectedRegistryUpdateProperties object itself.
     */
    public ConnectedRegistryUpdateProperties withClientTokenIds(List<String> clientTokenIds) {
        this.clientTokenIds = clientTokenIds;
        return this;
    }

    /**
     * Get the notificationsList property: The list of notifications subscription information for the connected
     * registry.
     * 
     * @return the notificationsList value.
     */
    public List<String> notificationsList() {
        return this.notificationsList;
    }

    /**
     * Set the notificationsList property: The list of notifications subscription information for the connected
     * registry.
     * 
     * @param notificationsList the notificationsList value to set.
     * @return the ConnectedRegistryUpdateProperties object itself.
     */
    public ConnectedRegistryUpdateProperties withNotificationsList(List<String> notificationsList) {
        this.notificationsList = notificationsList;
        return this;
    }

    /**
     * Get the garbageCollection property: The garbage collection properties of the connected registry.
     * 
     * @return the garbageCollection value.
     */
    public GarbageCollectionProperties garbageCollection() {
        return this.garbageCollection;
    }

    /**
     * Set the garbageCollection property: The garbage collection properties of the connected registry.
     * 
     * @param garbageCollection the garbageCollection value to set.
     * @return the ConnectedRegistryUpdateProperties object itself.
     */
    public ConnectedRegistryUpdateProperties withGarbageCollection(GarbageCollectionProperties garbageCollection) {
        this.garbageCollection = garbageCollection;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (syncProperties() != null) {
            syncProperties().validate();
        }
        if (logging() != null) {
            logging().validate();
        }
        if (garbageCollection() != null) {
            garbageCollection().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("syncProperties", this.syncProperties);
        jsonWriter.writeJsonField("logging", this.logging);
        jsonWriter.writeArrayField("clientTokenIds", this.clientTokenIds,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("notificationsList", this.notificationsList,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("garbageCollection", this.garbageCollection);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectedRegistryUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectedRegistryUpdateProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectedRegistryUpdateProperties.
     */
    public static ConnectedRegistryUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectedRegistryUpdateProperties deserializedConnectedRegistryUpdateProperties
                = new ConnectedRegistryUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("syncProperties".equals(fieldName)) {
                    deserializedConnectedRegistryUpdateProperties.syncProperties
                        = SyncUpdateProperties.fromJson(reader);
                } else if ("logging".equals(fieldName)) {
                    deserializedConnectedRegistryUpdateProperties.logging = LoggingProperties.fromJson(reader);
                } else if ("clientTokenIds".equals(fieldName)) {
                    List<String> clientTokenIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedConnectedRegistryUpdateProperties.clientTokenIds = clientTokenIds;
                } else if ("notificationsList".equals(fieldName)) {
                    List<String> notificationsList = reader.readArray(reader1 -> reader1.getString());
                    deserializedConnectedRegistryUpdateProperties.notificationsList = notificationsList;
                } else if ("garbageCollection".equals(fieldName)) {
                    deserializedConnectedRegistryUpdateProperties.garbageCollection
                        = GarbageCollectionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectedRegistryUpdateProperties;
        });
    }
}
