// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.ActivationProperties;
import com.azure.resourcemanager.containerregistry.models.ConnectedRegistryMode;
import com.azure.resourcemanager.containerregistry.models.ConnectionState;
import com.azure.resourcemanager.containerregistry.models.GarbageCollectionProperties;
import com.azure.resourcemanager.containerregistry.models.LoggingProperties;
import com.azure.resourcemanager.containerregistry.models.LoginServerProperties;
import com.azure.resourcemanager.containerregistry.models.ParentProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.StatusDetailProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * The properties of a connected registry.
 */
@Fluent
public final class ConnectedRegistryProperties implements JsonSerializable<ConnectedRegistryProperties> {
    /*
     * Provisioning state of the resource.
     */
    private ProvisioningState provisioningState;

    /*
     * The mode of the connected registry resource that indicates the permissions of the registry.
     */
    private ConnectedRegistryMode mode;

    /*
     * The current version of ACR runtime on the connected registry.
     */
    private String version;

    /*
     * The current connection state of the connected registry.
     */
    private ConnectionState connectionState;

    /*
     * The last activity time of the connected registry.
     */
    private OffsetDateTime lastActivityTime;

    /*
     * The activation properties of the connected registry.
     */
    private ActivationProperties activation;

    /*
     * The parent of the connected registry.
     */
    private ParentProperties parent;

    /*
     * The list of the ACR token resource IDs used to authenticate clients to the connected registry.
     */
    private List<String> clientTokenIds;

    /*
     * The login server properties of the connected registry.
     */
    private LoginServerProperties loginServer;

    /*
     * The logging properties of the connected registry.
     */
    private LoggingProperties logging;

    /*
     * The list of current statuses of the connected registry.
     */
    private List<StatusDetailProperties> statusDetails;

    /*
     * The list of notifications subscription information for the connected registry.
     */
    private List<String> notificationsList;

    /*
     * The garbage collection properties of the connected registry.
     */
    private GarbageCollectionProperties garbageCollection;

    /**
     * Creates an instance of ConnectedRegistryProperties class.
     */
    public ConnectedRegistryProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the mode property: The mode of the connected registry resource that indicates the permissions of the
     * registry.
     * 
     * @return the mode value.
     */
    public ConnectedRegistryMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: The mode of the connected registry resource that indicates the permissions of the
     * registry.
     * 
     * @param mode the mode value to set.
     * @return the ConnectedRegistryProperties object itself.
     */
    public ConnectedRegistryProperties withMode(ConnectedRegistryMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the version property: The current version of ACR runtime on the connected registry.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the connectionState property: The current connection state of the connected registry.
     * 
     * @return the connectionState value.
     */
    public ConnectionState connectionState() {
        return this.connectionState;
    }

    /**
     * Get the lastActivityTime property: The last activity time of the connected registry.
     * 
     * @return the lastActivityTime value.
     */
    public OffsetDateTime lastActivityTime() {
        return this.lastActivityTime;
    }

    /**
     * Get the activation property: The activation properties of the connected registry.
     * 
     * @return the activation value.
     */
    public ActivationProperties activation() {
        return this.activation;
    }

    /**
     * Get the parent property: The parent of the connected registry.
     * 
     * @return the parent value.
     */
    public ParentProperties parent() {
        return this.parent;
    }

    /**
     * Set the parent property: The parent of the connected registry.
     * 
     * @param parent the parent value to set.
     * @return the ConnectedRegistryProperties object itself.
     */
    public ConnectedRegistryProperties withParent(ParentProperties parent) {
        this.parent = parent;
        return this;
    }

    /**
     * Get the clientTokenIds property: The list of the ACR token resource IDs used to authenticate clients to the
     * connected registry.
     * 
     * @return the clientTokenIds value.
     */
    public List<String> clientTokenIds() {
        return this.clientTokenIds;
    }

    /**
     * Set the clientTokenIds property: The list of the ACR token resource IDs used to authenticate clients to the
     * connected registry.
     * 
     * @param clientTokenIds the clientTokenIds value to set.
     * @return the ConnectedRegistryProperties object itself.
     */
    public ConnectedRegistryProperties withClientTokenIds(List<String> clientTokenIds) {
        this.clientTokenIds = clientTokenIds;
        return this;
    }

    /**
     * Get the loginServer property: The login server properties of the connected registry.
     * 
     * @return the loginServer value.
     */
    public LoginServerProperties loginServer() {
        return this.loginServer;
    }

    /**
     * Set the loginServer property: The login server properties of the connected registry.
     * 
     * @param loginServer the loginServer value to set.
     * @return the ConnectedRegistryProperties object itself.
     */
    public ConnectedRegistryProperties withLoginServer(LoginServerProperties loginServer) {
        this.loginServer = loginServer;
        return this;
    }

    /**
     * Get the logging property: The logging properties of the connected registry.
     * 
     * @return the logging value.
     */
    public LoggingProperties logging() {
        return this.logging;
    }

    /**
     * Set the logging property: The logging properties of the connected registry.
     * 
     * @param logging the logging value to set.
     * @return the ConnectedRegistryProperties object itself.
     */
    public ConnectedRegistryProperties withLogging(LoggingProperties logging) {
        this.logging = logging;
        return this;
    }

    /**
     * Get the statusDetails property: The list of current statuses of the connected registry.
     * 
     * @return the statusDetails value.
     */
    public List<StatusDetailProperties> statusDetails() {
        return this.statusDetails;
    }

    /**
     * Get the notificationsList property: The list of notifications subscription information for the connected
     * registry.
     * 
     * @return the notificationsList value.
     */
    public List<String> notificationsList() {
        return this.notificationsList;
    }

    /**
     * Set the notificationsList property: The list of notifications subscription information for the connected
     * registry.
     * 
     * @param notificationsList the notificationsList value to set.
     * @return the ConnectedRegistryProperties object itself.
     */
    public ConnectedRegistryProperties withNotificationsList(List<String> notificationsList) {
        this.notificationsList = notificationsList;
        return this;
    }

    /**
     * Get the garbageCollection property: The garbage collection properties of the connected registry.
     * 
     * @return the garbageCollection value.
     */
    public GarbageCollectionProperties garbageCollection() {
        return this.garbageCollection;
    }

    /**
     * Set the garbageCollection property: The garbage collection properties of the connected registry.
     * 
     * @param garbageCollection the garbageCollection value to set.
     * @return the ConnectedRegistryProperties object itself.
     */
    public ConnectedRegistryProperties withGarbageCollection(GarbageCollectionProperties garbageCollection) {
        this.garbageCollection = garbageCollection;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (mode() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property mode in model ConnectedRegistryProperties"));
        }
        if (activation() != null) {
            activation().validate();
        }
        if (parent() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property parent in model ConnectedRegistryProperties"));
        } else {
            parent().validate();
        }
        if (loginServer() != null) {
            loginServer().validate();
        }
        if (logging() != null) {
            logging().validate();
        }
        if (statusDetails() != null) {
            statusDetails().forEach(e -> e.validate());
        }
        if (garbageCollection() != null) {
            garbageCollection().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ConnectedRegistryProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeJsonField("parent", this.parent);
        jsonWriter.writeArrayField("clientTokenIds", this.clientTokenIds,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("loginServer", this.loginServer);
        jsonWriter.writeJsonField("logging", this.logging);
        jsonWriter.writeArrayField("notificationsList", this.notificationsList,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("garbageCollection", this.garbageCollection);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectedRegistryProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectedRegistryProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectedRegistryProperties.
     */
    public static ConnectedRegistryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectedRegistryProperties deserializedConnectedRegistryProperties = new ConnectedRegistryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mode".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.mode = ConnectedRegistryMode.fromString(reader.getString());
                } else if ("parent".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.parent = ParentProperties.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("version".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.version = reader.getString();
                } else if ("connectionState".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.connectionState
                        = ConnectionState.fromString(reader.getString());
                } else if ("lastActivityTime".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.lastActivityTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("activation".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.activation = ActivationProperties.fromJson(reader);
                } else if ("clientTokenIds".equals(fieldName)) {
                    List<String> clientTokenIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedConnectedRegistryProperties.clientTokenIds = clientTokenIds;
                } else if ("loginServer".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.loginServer = LoginServerProperties.fromJson(reader);
                } else if ("logging".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.logging = LoggingProperties.fromJson(reader);
                } else if ("statusDetails".equals(fieldName)) {
                    List<StatusDetailProperties> statusDetails
                        = reader.readArray(reader1 -> StatusDetailProperties.fromJson(reader1));
                    deserializedConnectedRegistryProperties.statusDetails = statusDetails;
                } else if ("notificationsList".equals(fieldName)) {
                    List<String> notificationsList = reader.readArray(reader1 -> reader1.getString());
                    deserializedConnectedRegistryProperties.notificationsList = notificationsList;
                } else if ("garbageCollection".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.garbageCollection
                        = GarbageCollectionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectedRegistryProperties;
        });
    }
}
