// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

/**
 * The parameters for updating the sync properties of the connected registry with its parent.
 */
@Fluent
public final class SyncUpdateProperties implements JsonSerializable<SyncUpdateProperties> {
    /*
     * The cron expression indicating the schedule that the connected registry will sync with its parent.
     */
    private String schedule;

    /*
     * The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format
     * P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
     */
    private Duration syncWindow;

    /*
     * The period of time for which a message is available to sync before it is expired. Specify the duration using the
     * format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
     */
    private Duration messageTtl;

    /**
     * Creates an instance of SyncUpdateProperties class.
     */
    public SyncUpdateProperties() {
    }

    /**
     * Get the schedule property: The cron expression indicating the schedule that the connected registry will sync with
     * its parent.
     * 
     * @return the schedule value.
     */
    public String schedule() {
        return this.schedule;
    }

    /**
     * Set the schedule property: The cron expression indicating the schedule that the connected registry will sync with
     * its parent.
     * 
     * @param schedule the schedule value to set.
     * @return the SyncUpdateProperties object itself.
     */
    public SyncUpdateProperties withSchedule(String schedule) {
        this.schedule = schedule;
        return this;
    }

    /**
     * Get the syncWindow property: The time window during which sync is enabled for each schedule occurrence. Specify
     * the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
     * 
     * @return the syncWindow value.
     */
    public Duration syncWindow() {
        return this.syncWindow;
    }

    /**
     * Set the syncWindow property: The time window during which sync is enabled for each schedule occurrence. Specify
     * the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
     * 
     * @param syncWindow the syncWindow value to set.
     * @return the SyncUpdateProperties object itself.
     */
    public SyncUpdateProperties withSyncWindow(Duration syncWindow) {
        this.syncWindow = syncWindow;
        return this;
    }

    /**
     * Get the messageTtl property: The period of time for which a message is available to sync before it is expired.
     * Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
     * 
     * @return the messageTtl value.
     */
    public Duration messageTtl() {
        return this.messageTtl;
    }

    /**
     * Set the messageTtl property: The period of time for which a message is available to sync before it is expired.
     * Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
     * 
     * @param messageTtl the messageTtl value to set.
     * @return the SyncUpdateProperties object itself.
     */
    public SyncUpdateProperties withMessageTtl(Duration messageTtl) {
        this.messageTtl = messageTtl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("schedule", this.schedule);
        jsonWriter.writeStringField("syncWindow", CoreUtils.durationToStringWithDays(this.syncWindow));
        jsonWriter.writeStringField("messageTtl", CoreUtils.durationToStringWithDays(this.messageTtl));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SyncUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SyncUpdateProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SyncUpdateProperties.
     */
    public static SyncUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SyncUpdateProperties deserializedSyncUpdateProperties = new SyncUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("schedule".equals(fieldName)) {
                    deserializedSyncUpdateProperties.schedule = reader.getString();
                } else if ("syncWindow".equals(fieldName)) {
                    deserializedSyncUpdateProperties.syncWindow
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("messageTtl".equals(fieldName)) {
                    deserializedSyncUpdateProperties.messageTtl
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSyncUpdateProperties;
        });
    }
}
