// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The definition of Azure Monitoring list.
 */
@Fluent
public final class OperationServiceSpecificationDefinition
    implements JsonSerializable<OperationServiceSpecificationDefinition> {
    /*
     * A list of Azure Monitoring metrics definition.
     */
    private List<OperationMetricSpecificationDefinition> metricSpecifications;

    /*
     * A list of Azure Monitoring log definitions.
     */
    private List<OperationLogSpecificationDefinition> logSpecifications;

    /**
     * Creates an instance of OperationServiceSpecificationDefinition class.
     */
    public OperationServiceSpecificationDefinition() {
    }

    /**
     * Get the metricSpecifications property: A list of Azure Monitoring metrics definition.
     * 
     * @return the metricSpecifications value.
     */
    public List<OperationMetricSpecificationDefinition> metricSpecifications() {
        return this.metricSpecifications;
    }

    /**
     * Set the metricSpecifications property: A list of Azure Monitoring metrics definition.
     * 
     * @param metricSpecifications the metricSpecifications value to set.
     * @return the OperationServiceSpecificationDefinition object itself.
     */
    public OperationServiceSpecificationDefinition
        withMetricSpecifications(List<OperationMetricSpecificationDefinition> metricSpecifications) {
        this.metricSpecifications = metricSpecifications;
        return this;
    }

    /**
     * Get the logSpecifications property: A list of Azure Monitoring log definitions.
     * 
     * @return the logSpecifications value.
     */
    public List<OperationLogSpecificationDefinition> logSpecifications() {
        return this.logSpecifications;
    }

    /**
     * Set the logSpecifications property: A list of Azure Monitoring log definitions.
     * 
     * @param logSpecifications the logSpecifications value to set.
     * @return the OperationServiceSpecificationDefinition object itself.
     */
    public OperationServiceSpecificationDefinition
        withLogSpecifications(List<OperationLogSpecificationDefinition> logSpecifications) {
        this.logSpecifications = logSpecifications;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (metricSpecifications() != null) {
            metricSpecifications().forEach(e -> e.validate());
        }
        if (logSpecifications() != null) {
            logSpecifications().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("metricSpecifications", this.metricSpecifications,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("logSpecifications", this.logSpecifications,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationServiceSpecificationDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationServiceSpecificationDefinition if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationServiceSpecificationDefinition.
     */
    public static OperationServiceSpecificationDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationServiceSpecificationDefinition deserializedOperationServiceSpecificationDefinition
                = new OperationServiceSpecificationDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("metricSpecifications".equals(fieldName)) {
                    List<OperationMetricSpecificationDefinition> metricSpecifications
                        = reader.readArray(reader1 -> OperationMetricSpecificationDefinition.fromJson(reader1));
                    deserializedOperationServiceSpecificationDefinition.metricSpecifications = metricSpecifications;
                } else if ("logSpecifications".equals(fieldName)) {
                    List<OperationLogSpecificationDefinition> logSpecifications
                        = reader.readArray(reader1 -> OperationLogSpecificationDefinition.fromJson(reader1));
                    deserializedOperationServiceSpecificationDefinition.logSpecifications = logSpecifications;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationServiceSpecificationDefinition;
        });
    }
}
