// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.CacheRuleUpdateProperties;
import java.io.IOException;

/**
 * The parameters for updating a cache rule.
 */
@Fluent
public final class CacheRuleUpdateParameters implements JsonSerializable<CacheRuleUpdateParameters> {
    /*
     * The properties of the cache rule update parameters.
     */
    private CacheRuleUpdateProperties innerProperties;

    /**
     * Creates an instance of CacheRuleUpdateParameters class.
     */
    public CacheRuleUpdateParameters() {
    }

    /**
     * Get the innerProperties property: The properties of the cache rule update parameters.
     * 
     * @return the innerProperties value.
     */
    private CacheRuleUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the credentialSetResourceId property: The ARM resource ID of the credential store which is associated with
     * the Cache rule.
     * 
     * @return the credentialSetResourceId value.
     */
    public String credentialSetResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().credentialSetResourceId();
    }

    /**
     * Set the credentialSetResourceId property: The ARM resource ID of the credential store which is associated with
     * the Cache rule.
     * 
     * @param credentialSetResourceId the credentialSetResourceId value to set.
     * @return the CacheRuleUpdateParameters object itself.
     */
    public CacheRuleUpdateParameters withCredentialSetResourceId(String credentialSetResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CacheRuleUpdateProperties();
        }
        this.innerProperties().withCredentialSetResourceId(credentialSetResourceId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CacheRuleUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CacheRuleUpdateParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CacheRuleUpdateParameters.
     */
    public static CacheRuleUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CacheRuleUpdateParameters deserializedCacheRuleUpdateParameters = new CacheRuleUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedCacheRuleUpdateParameters.innerProperties = CacheRuleUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCacheRuleUpdateParameters;
        });
    }
}
