/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.TaskPropertiesUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.azure.resourcemanager.containerregistry.models.Credentials;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.PlatformUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.TaskStatus;
import com.azure.resourcemanager.containerregistry.models.TaskStepUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.TriggerUpdateParameters;
import java.io.IOException;
import java.util.Map;

public final class TaskUpdateParameters
implements JsonSerializable<TaskUpdateParameters> {
    private IdentityProperties identity;
    private TaskPropertiesUpdateParameters innerProperties;
    private Map<String, String> tags;

    public IdentityProperties identity() {
        return this.identity;
    }

    public TaskUpdateParameters withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    private TaskPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public TaskUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public TaskStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public TaskUpdateParameters withStatus(TaskStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public PlatformUpdateParameters platform() {
        return this.innerProperties() == null ? null : this.innerProperties().platform();
    }

    public TaskUpdateParameters withPlatform(PlatformUpdateParameters platform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withPlatform(platform);
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().agentConfiguration();
    }

    public TaskUpdateParameters withAgentConfiguration(AgentProperties agentConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withAgentConfiguration(agentConfiguration);
        return this;
    }

    public String agentPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().agentPoolName();
    }

    public TaskUpdateParameters withAgentPoolName(String agentPoolName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withAgentPoolName(agentPoolName);
        return this;
    }

    public Integer timeout() {
        return this.innerProperties() == null ? null : this.innerProperties().timeout();
    }

    public TaskUpdateParameters withTimeout(Integer timeout) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withTimeout(timeout);
        return this;
    }

    public TaskStepUpdateParameters step() {
        return this.innerProperties() == null ? null : this.innerProperties().step();
    }

    public TaskUpdateParameters withStep(TaskStepUpdateParameters step) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withStep(step);
        return this;
    }

    public TriggerUpdateParameters trigger() {
        return this.innerProperties() == null ? null : this.innerProperties().trigger();
    }

    public TaskUpdateParameters withTrigger(TriggerUpdateParameters trigger) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withTrigger(trigger);
        return this;
    }

    public Credentials credentials() {
        return this.innerProperties() == null ? null : this.innerProperties().credentials();
    }

    public TaskUpdateParameters withCredentials(Credentials credentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withCredentials(credentials);
        return this;
    }

    public String logTemplate() {
        return this.innerProperties() == null ? null : this.innerProperties().logTemplate();
    }

    public TaskUpdateParameters withLogTemplate(String logTemplate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withLogTemplate(logTemplate);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static TaskUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (TaskUpdateParameters)jsonReader.readObject(reader -> {
            TaskUpdateParameters deserializedTaskUpdateParameters = new TaskUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedTaskUpdateParameters.identity = IdentityProperties.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTaskUpdateParameters.innerProperties = TaskPropertiesUpdateParameters.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedTaskUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskUpdateParameters;
        });
    }
}

