/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.ReplicationInner;
import java.io.IOException;
import java.util.List;

public final class ReplicationListResult
implements JsonSerializable<ReplicationListResult> {
    private List<ReplicationInner> value;
    private String nextLink;

    public List<ReplicationInner> value() {
        return this.value;
    }

    public ReplicationListResult withValue(List<ReplicationInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ReplicationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ReplicationListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicationListResult)jsonReader.readObject(reader -> {
            ReplicationListResult deserializedReplicationListResult = new ReplicationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedReplicationListResult.value = value = reader.readArray(reader1 -> ReplicationInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedReplicationListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicationListResult;
        });
    }
}

