/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.TokenType;
import java.io.IOException;

public final class AuthInfoUpdateParameters
implements JsonSerializable<AuthInfoUpdateParameters> {
    private TokenType tokenType;
    private String token;
    private String refreshToken;
    private String scope;
    private Integer expiresIn;

    public TokenType tokenType() {
        return this.tokenType;
    }

    public AuthInfoUpdateParameters withTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public String token() {
        return this.token;
    }

    public AuthInfoUpdateParameters withToken(String token) {
        this.token = token;
        return this;
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    public AuthInfoUpdateParameters withRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public AuthInfoUpdateParameters withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public Integer expiresIn() {
        return this.expiresIn;
    }

    public AuthInfoUpdateParameters withExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tokenType", this.tokenType == null ? null : this.tokenType.toString());
        jsonWriter.writeStringField("token", this.token);
        jsonWriter.writeStringField("refreshToken", this.refreshToken);
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeNumberField("expiresIn", (Number)this.expiresIn);
        return jsonWriter.writeEndObject();
    }

    public static AuthInfoUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AuthInfoUpdateParameters)jsonReader.readObject(reader -> {
            AuthInfoUpdateParameters deserializedAuthInfoUpdateParameters = new AuthInfoUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tokenType".equals(fieldName)) {
                    deserializedAuthInfoUpdateParameters.tokenType = TokenType.fromString(reader.getString());
                    continue;
                }
                if ("token".equals(fieldName)) {
                    deserializedAuthInfoUpdateParameters.token = reader.getString();
                    continue;
                }
                if ("refreshToken".equals(fieldName)) {
                    deserializedAuthInfoUpdateParameters.refreshToken = reader.getString();
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedAuthInfoUpdateParameters.scope = reader.getString();
                    continue;
                }
                if ("expiresIn".equals(fieldName)) {
                    deserializedAuthInfoUpdateParameters.expiresIn = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthInfoUpdateParameters;
        });
    }
}

