// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The health status of credential.
 */
public final class CredentialHealthStatus extends ExpandableStringEnum<CredentialHealthStatus> {
    /**
     * Static value Healthy for CredentialHealthStatus.
     */
    public static final CredentialHealthStatus HEALTHY = fromString("Healthy");

    /**
     * Static value Unhealthy for CredentialHealthStatus.
     */
    public static final CredentialHealthStatus UNHEALTHY = fromString("Unhealthy");

    /**
     * Creates a new instance of CredentialHealthStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public CredentialHealthStatus() {
    }

    /**
     * Creates or finds a CredentialHealthStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding CredentialHealthStatus.
     */
    public static CredentialHealthStatus fromString(String name) {
        return fromString(name, CredentialHealthStatus.class);
    }

    /**
     * Gets known CredentialHealthStatus values.
     * 
     * @return known CredentialHealthStatus values.
     */
    public static Collection<CredentialHealthStatus> values() {
        return values(CredentialHealthStatus.class);
    }
}
