// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The event request message sent to the service URI.
 */
@Fluent
public final class EventRequestMessage implements JsonSerializable<EventRequestMessage> {
    /*
     * The content of the event request message.
     */
    private EventContent content;

    /*
     * The headers of the event request message.
     */
    private Map<String, String> headers;

    /*
     * The HTTP method used to send the event request message.
     */
    private String method;

    /*
     * The URI used to send the event request message.
     */
    private String requestUri;

    /*
     * The HTTP message version.
     */
    private String version;

    /**
     * Creates an instance of EventRequestMessage class.
     */
    public EventRequestMessage() {
    }

    /**
     * Get the content property: The content of the event request message.
     * 
     * @return the content value.
     */
    public EventContent content() {
        return this.content;
    }

    /**
     * Set the content property: The content of the event request message.
     * 
     * @param content the content value to set.
     * @return the EventRequestMessage object itself.
     */
    public EventRequestMessage withContent(EventContent content) {
        this.content = content;
        return this;
    }

    /**
     * Get the headers property: The headers of the event request message.
     * 
     * @return the headers value.
     */
    public Map<String, String> headers() {
        return this.headers;
    }

    /**
     * Set the headers property: The headers of the event request message.
     * 
     * @param headers the headers value to set.
     * @return the EventRequestMessage object itself.
     */
    public EventRequestMessage withHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    /**
     * Get the method property: The HTTP method used to send the event request message.
     * 
     * @return the method value.
     */
    public String method() {
        return this.method;
    }

    /**
     * Set the method property: The HTTP method used to send the event request message.
     * 
     * @param method the method value to set.
     * @return the EventRequestMessage object itself.
     */
    public EventRequestMessage withMethod(String method) {
        this.method = method;
        return this;
    }

    /**
     * Get the requestUri property: The URI used to send the event request message.
     * 
     * @return the requestUri value.
     */
    public String requestUri() {
        return this.requestUri;
    }

    /**
     * Set the requestUri property: The URI used to send the event request message.
     * 
     * @param requestUri the requestUri value to set.
     * @return the EventRequestMessage object itself.
     */
    public EventRequestMessage withRequestUri(String requestUri) {
        this.requestUri = requestUri;
        return this;
    }

    /**
     * Get the version property: The HTTP message version.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: The HTTP message version.
     * 
     * @param version the version value to set.
     * @return the EventRequestMessage object itself.
     */
    public EventRequestMessage withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (content() != null) {
            content().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("content", this.content);
        jsonWriter.writeMapField("headers", this.headers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("method", this.method);
        jsonWriter.writeStringField("requestUri", this.requestUri);
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EventRequestMessage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EventRequestMessage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EventRequestMessage.
     */
    public static EventRequestMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventRequestMessage deserializedEventRequestMessage = new EventRequestMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("content".equals(fieldName)) {
                    deserializedEventRequestMessage.content = EventContent.fromJson(reader);
                } else if ("headers".equals(fieldName)) {
                    Map<String, String> headers = reader.readMap(reader1 -> reader1.getString());
                    deserializedEventRequestMessage.headers = headers;
                } else if ("method".equals(fieldName)) {
                    deserializedEventRequestMessage.method = reader.getString();
                } else if ("requestUri".equals(fieldName)) {
                    deserializedEventRequestMessage.requestUri = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedEventRequestMessage.version = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEventRequestMessage;
        });
    }
}
