// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.OS;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import java.io.IOException;

/**
 * The properties of agent pool.
 */
@Fluent
public final class AgentPoolProperties implements JsonSerializable<AgentPoolProperties> {
    /*
     * The count of agent machine
     */
    private Integer count;

    /*
     * The Tier of agent machine
     */
    private String tier;

    /*
     * The OS of agent machine
     */
    private OS os;

    /*
     * The Virtual Network Subnet Resource Id of the agent machine
     */
    private String virtualNetworkSubnetResourceId;

    /*
     * The provisioning state of this agent pool
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of AgentPoolProperties class.
     */
    public AgentPoolProperties() {
    }

    /**
     * Get the count property: The count of agent machine.
     * 
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count property: The count of agent machine.
     * 
     * @param count the count value to set.
     * @return the AgentPoolProperties object itself.
     */
    public AgentPoolProperties withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Get the tier property: The Tier of agent machine.
     * 
     * @return the tier value.
     */
    public String tier() {
        return this.tier;
    }

    /**
     * Set the tier property: The Tier of agent machine.
     * 
     * @param tier the tier value to set.
     * @return the AgentPoolProperties object itself.
     */
    public AgentPoolProperties withTier(String tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Get the os property: The OS of agent machine.
     * 
     * @return the os value.
     */
    public OS os() {
        return this.os;
    }

    /**
     * Set the os property: The OS of agent machine.
     * 
     * @param os the os value to set.
     * @return the AgentPoolProperties object itself.
     */
    public AgentPoolProperties withOs(OS os) {
        this.os = os;
        return this;
    }

    /**
     * Get the virtualNetworkSubnetResourceId property: The Virtual Network Subnet Resource Id of the agent machine.
     * 
     * @return the virtualNetworkSubnetResourceId value.
     */
    public String virtualNetworkSubnetResourceId() {
        return this.virtualNetworkSubnetResourceId;
    }

    /**
     * Set the virtualNetworkSubnetResourceId property: The Virtual Network Subnet Resource Id of the agent machine.
     * 
     * @param virtualNetworkSubnetResourceId the virtualNetworkSubnetResourceId value to set.
     * @return the AgentPoolProperties object itself.
     */
    public AgentPoolProperties withVirtualNetworkSubnetResourceId(String virtualNetworkSubnetResourceId) {
        this.virtualNetworkSubnetResourceId = virtualNetworkSubnetResourceId;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of this agent pool.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("count", this.count);
        jsonWriter.writeStringField("tier", this.tier);
        jsonWriter.writeStringField("os", this.os == null ? null : this.os.toString());
        jsonWriter.writeStringField("virtualNetworkSubnetResourceId", this.virtualNetworkSubnetResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentPoolProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentPoolProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AgentPoolProperties.
     */
    public static AgentPoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentPoolProperties deserializedAgentPoolProperties = new AgentPoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("count".equals(fieldName)) {
                    deserializedAgentPoolProperties.count = reader.getNullable(JsonReader::getInt);
                } else if ("tier".equals(fieldName)) {
                    deserializedAgentPoolProperties.tier = reader.getString();
                } else if ("os".equals(fieldName)) {
                    deserializedAgentPoolProperties.os = OS.fromString(reader.getString());
                } else if ("virtualNetworkSubnetResourceId".equals(fieldName)) {
                    deserializedAgentPoolProperties.virtualNetworkSubnetResourceId = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedAgentPoolProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentPoolProperties;
        });
    }
}
