// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.EncryptionProperty;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleBypassOptions;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.azure.resourcemanager.containerregistry.models.Policies;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerregistry.models.Sku;
import com.azure.resourcemanager.containerregistry.models.Status;
import com.azure.resourcemanager.containerregistry.models.ZoneRedundancy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * An object that represents a container registry.
 */
@Fluent
public final class RegistryInner extends Resource {
    /*
     * The SKU of the container registry.
     */
    private Sku sku;

    /*
     * The identity of the container registry.
     */
    private IdentityProperties identity;

    /*
     * The properties of the container registry.
     */
    private RegistryProperties innerProperties;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of RegistryInner class.
     */
    public RegistryInner() {
    }

    /**
     * Get the sku property: The SKU of the container registry.
     * 
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The SKU of the container registry.
     * 
     * @param sku the sku value to set.
     * @return the RegistryInner object itself.
     */
    public RegistryInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the identity property: The identity of the container registry.
     * 
     * @return the identity value.
     */
    public IdentityProperties identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The identity of the container registry.
     * 
     * @param identity the identity value to set.
     * @return the RegistryInner object itself.
     */
    public RegistryInner withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the innerProperties property: The properties of the container registry.
     * 
     * @return the innerProperties value.
     */
    private RegistryProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RegistryInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RegistryInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the loginServer property: The URL that can be used to log into the container registry.
     * 
     * @return the loginServer value.
     */
    public String loginServer() {
        return this.innerProperties() == null ? null : this.innerProperties().loginServer();
    }

    /**
     * Get the creationDate property: The creation date of the container registry in ISO8601 format.
     * 
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    /**
     * Get the provisioningState property: The provisioning state of the container registry at the time the operation
     * was called.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the status property: The status of the container registry at the time the operation was called.
     * 
     * @return the status value.
     */
    public Status status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the adminUserEnabled property: The value that indicates whether the admin user is enabled.
     * 
     * @return the adminUserEnabled value.
     */
    public Boolean adminUserEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().adminUserEnabled();
    }

    /**
     * Set the adminUserEnabled property: The value that indicates whether the admin user is enabled.
     * 
     * @param adminUserEnabled the adminUserEnabled value to set.
     * @return the RegistryInner object itself.
     */
    public RegistryInner withAdminUserEnabled(Boolean adminUserEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withAdminUserEnabled(adminUserEnabled);
        return this;
    }

    /**
     * Get the networkRuleSet property: The network rule set for a container registry.
     * 
     * @return the networkRuleSet value.
     */
    public NetworkRuleSet networkRuleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleSet();
    }

    /**
     * Set the networkRuleSet property: The network rule set for a container registry.
     * 
     * @param networkRuleSet the networkRuleSet value to set.
     * @return the RegistryInner object itself.
     */
    public RegistryInner withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withNetworkRuleSet(networkRuleSet);
        return this;
    }

    /**
     * Get the policies property: The policies for a container registry.
     * 
     * @return the policies value.
     */
    public Policies policies() {
        return this.innerProperties() == null ? null : this.innerProperties().policies();
    }

    /**
     * Set the policies property: The policies for a container registry.
     * 
     * @param policies the policies value to set.
     * @return the RegistryInner object itself.
     */
    public RegistryInner withPolicies(Policies policies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withPolicies(policies);
        return this;
    }

    /**
     * Get the encryption property: The encryption settings of container registry.
     * 
     * @return the encryption value.
     */
    public EncryptionProperty encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    /**
     * Set the encryption property: The encryption settings of container registry.
     * 
     * @param encryption the encryption value to set.
     * @return the RegistryInner object itself.
     */
    public RegistryInner withEncryption(EncryptionProperty encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    /**
     * Get the dataEndpointEnabled property: Enable a single data endpoint per region for serving data.
     * 
     * @return the dataEndpointEnabled value.
     */
    public Boolean dataEndpointEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEndpointEnabled();
    }

    /**
     * Set the dataEndpointEnabled property: Enable a single data endpoint per region for serving data.
     * 
     * @param dataEndpointEnabled the dataEndpointEnabled value to set.
     * @return the RegistryInner object itself.
     */
    public RegistryInner withDataEndpointEnabled(Boolean dataEndpointEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withDataEndpointEnabled(dataEndpointEnabled);
        return this;
    }

    /**
     * Get the dataEndpointHostNames property: List of host names that will serve data when dataEndpointEnabled is true.
     * 
     * @return the dataEndpointHostNames value.
     */
    public List<String> dataEndpointHostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEndpointHostNames();
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connections for a container registry.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public network access is allowed for the container registry.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public network access is allowed for the container registry.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the RegistryInner object itself.
     */
    public RegistryInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    /**
     * Get the networkRuleBypassOptions property: Whether to allow trusted Azure services to access a network restricted
     * registry.
     * 
     * @return the networkRuleBypassOptions value.
     */
    public NetworkRuleBypassOptions networkRuleBypassOptions() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleBypassOptions();
    }

    /**
     * Set the networkRuleBypassOptions property: Whether to allow trusted Azure services to access a network restricted
     * registry.
     * 
     * @param networkRuleBypassOptions the networkRuleBypassOptions value to set.
     * @return the RegistryInner object itself.
     */
    public RegistryInner withNetworkRuleBypassOptions(NetworkRuleBypassOptions networkRuleBypassOptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withNetworkRuleBypassOptions(networkRuleBypassOptions);
        return this;
    }

    /**
     * Get the zoneRedundancy property: Whether or not zone redundancy is enabled for this container registry.
     * 
     * @return the zoneRedundancy value.
     */
    public ZoneRedundancy zoneRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundancy();
    }

    /**
     * Set the zoneRedundancy property: Whether or not zone redundancy is enabled for this container registry.
     * 
     * @param zoneRedundancy the zoneRedundancy value to set.
     * @return the RegistryInner object itself.
     */
    public RegistryInner withZoneRedundancy(ZoneRedundancy zoneRedundancy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryProperties();
        }
        this.innerProperties().withZoneRedundancy(zoneRedundancy);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property sku in model RegistryInner"));
        } else {
            sku().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RegistryInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RegistryInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RegistryInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RegistryInner.
     */
    public static RegistryInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RegistryInner deserializedRegistryInner = new RegistryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRegistryInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRegistryInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRegistryInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedRegistryInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRegistryInner.withTags(tags);
                } else if ("sku".equals(fieldName)) {
                    deserializedRegistryInner.sku = Sku.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    deserializedRegistryInner.identity = IdentityProperties.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedRegistryInner.innerProperties = RegistryProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedRegistryInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRegistryInner;
        });
    }
}
