// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.RunInner;
import java.io.IOException;
import java.util.List;

/**
 * Collection of runs.
 */
@Fluent
public final class RunListResult implements JsonSerializable<RunListResult> {
    /*
     * The collection value.
     */
    private List<RunInner> value;

    /*
     * The URI that can be used to request the next set of paged results.
     */
    private String nextLink;

    /**
     * Creates an instance of RunListResult class.
     */
    public RunListResult() {
    }

    /**
     * Get the value property: The collection value.
     * 
     * @return the value value.
     */
    public List<RunInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The collection value.
     * 
     * @param value the value value to set.
     * @return the RunListResult object itself.
     */
    public RunListResult withValue(List<RunInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI that can be used to request the next set of paged results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI that can be used to request the next set of paged results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the RunListResult object itself.
     */
    public RunListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RunListResult.
     */
    public static RunListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunListResult deserializedRunListResult = new RunListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RunInner> value = reader.readArray(reader1 -> RunInner.fromJson(reader1));
                    deserializedRunListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRunListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRunListResult;
        });
    }
}
