// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The definition of Azure Monitoring metric.
 */
@Fluent
public final class OperationMetricSpecificationDefinition
    implements JsonSerializable<OperationMetricSpecificationDefinition> {
    /*
     * Metric name.
     */
    private String name;

    /*
     * Metric display name.
     */
    private String displayName;

    /*
     * Metric description.
     */
    private String displayDescription;

    /*
     * Metric unit.
     */
    private String unit;

    /*
     * Metric aggregation type.
     */
    private String aggregationType;

    /*
     * Internal metric name.
     */
    private String internalMetricName;

    /**
     * Creates an instance of OperationMetricSpecificationDefinition class.
     */
    public OperationMetricSpecificationDefinition() {
    }

    /**
     * Get the name property: Metric name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Metric name.
     * 
     * @param name the name value to set.
     * @return the OperationMetricSpecificationDefinition object itself.
     */
    public OperationMetricSpecificationDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the displayName property: Metric display name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Metric display name.
     * 
     * @param displayName the displayName value to set.
     * @return the OperationMetricSpecificationDefinition object itself.
     */
    public OperationMetricSpecificationDefinition withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the displayDescription property: Metric description.
     * 
     * @return the displayDescription value.
     */
    public String displayDescription() {
        return this.displayDescription;
    }

    /**
     * Set the displayDescription property: Metric description.
     * 
     * @param displayDescription the displayDescription value to set.
     * @return the OperationMetricSpecificationDefinition object itself.
     */
    public OperationMetricSpecificationDefinition withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    /**
     * Get the unit property: Metric unit.
     * 
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Set the unit property: Metric unit.
     * 
     * @param unit the unit value to set.
     * @return the OperationMetricSpecificationDefinition object itself.
     */
    public OperationMetricSpecificationDefinition withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get the aggregationType property: Metric aggregation type.
     * 
     * @return the aggregationType value.
     */
    public String aggregationType() {
        return this.aggregationType;
    }

    /**
     * Set the aggregationType property: Metric aggregation type.
     * 
     * @param aggregationType the aggregationType value to set.
     * @return the OperationMetricSpecificationDefinition object itself.
     */
    public OperationMetricSpecificationDefinition withAggregationType(String aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    /**
     * Get the internalMetricName property: Internal metric name.
     * 
     * @return the internalMetricName value.
     */
    public String internalMetricName() {
        return this.internalMetricName;
    }

    /**
     * Set the internalMetricName property: Internal metric name.
     * 
     * @param internalMetricName the internalMetricName value to set.
     * @return the OperationMetricSpecificationDefinition object itself.
     */
    public OperationMetricSpecificationDefinition withInternalMetricName(String internalMetricName) {
        this.internalMetricName = internalMetricName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeStringField("aggregationType", this.aggregationType);
        jsonWriter.writeStringField("internalMetricName", this.internalMetricName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationMetricSpecificationDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationMetricSpecificationDefinition if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationMetricSpecificationDefinition.
     */
    public static OperationMetricSpecificationDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationMetricSpecificationDefinition deserializedOperationMetricSpecificationDefinition
                = new OperationMetricSpecificationDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedOperationMetricSpecificationDefinition.name = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedOperationMetricSpecificationDefinition.displayName = reader.getString();
                } else if ("displayDescription".equals(fieldName)) {
                    deserializedOperationMetricSpecificationDefinition.displayDescription = reader.getString();
                } else if ("unit".equals(fieldName)) {
                    deserializedOperationMetricSpecificationDefinition.unit = reader.getString();
                } else if ("aggregationType".equals(fieldName)) {
                    deserializedOperationMetricSpecificationDefinition.aggregationType = reader.getString();
                } else if ("internalMetricName".equals(fieldName)) {
                    deserializedOperationMetricSpecificationDefinition.internalMetricName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationMetricSpecificationDefinition;
        });
    }
}
