// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.RunRequest;
import java.io.IOException;

/**
 * The properties of task run.
 */
@Fluent
public final class TaskRunPropertiesInner implements JsonSerializable<TaskRunPropertiesInner> {
    /*
     * The provisioning state of this task run
     */
    private ProvisioningState provisioningState;

    /*
     * The request (parameters) for the run
     */
    private RunRequest runRequest;

    /*
     * The result of this task run
     */
    private RunInner runResult;

    /*
     * How the run should be forced to rerun even if the run request configuration has not changed
     */
    private String forceUpdateTag;

    /**
     * Creates an instance of TaskRunPropertiesInner class.
     */
    public TaskRunPropertiesInner() {
    }

    /**
     * Get the provisioningState property: The provisioning state of this task run.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the runRequest property: The request (parameters) for the run.
     * 
     * @return the runRequest value.
     */
    public RunRequest runRequest() {
        return this.runRequest;
    }

    /**
     * Set the runRequest property: The request (parameters) for the run.
     * 
     * @param runRequest the runRequest value to set.
     * @return the TaskRunPropertiesInner object itself.
     */
    public TaskRunPropertiesInner withRunRequest(RunRequest runRequest) {
        this.runRequest = runRequest;
        return this;
    }

    /**
     * Get the runResult property: The result of this task run.
     * 
     * @return the runResult value.
     */
    public RunInner runResult() {
        return this.runResult;
    }

    /**
     * Get the forceUpdateTag property: How the run should be forced to rerun even if the run request configuration has
     * not changed.
     * 
     * @return the forceUpdateTag value.
     */
    public String forceUpdateTag() {
        return this.forceUpdateTag;
    }

    /**
     * Set the forceUpdateTag property: How the run should be forced to rerun even if the run request configuration has
     * not changed.
     * 
     * @param forceUpdateTag the forceUpdateTag value to set.
     * @return the TaskRunPropertiesInner object itself.
     */
    public TaskRunPropertiesInner withForceUpdateTag(String forceUpdateTag) {
        this.forceUpdateTag = forceUpdateTag;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (runRequest() != null) {
            runRequest().validate();
        }
        if (runResult() != null) {
            runResult().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("runRequest", this.runRequest);
        jsonWriter.writeStringField("forceUpdateTag", this.forceUpdateTag);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TaskRunPropertiesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TaskRunPropertiesInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TaskRunPropertiesInner.
     */
    public static TaskRunPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TaskRunPropertiesInner deserializedTaskRunPropertiesInner = new TaskRunPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedTaskRunPropertiesInner.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("runRequest".equals(fieldName)) {
                    deserializedTaskRunPropertiesInner.runRequest = RunRequest.fromJson(reader);
                } else if ("runResult".equals(fieldName)) {
                    deserializedTaskRunPropertiesInner.runResult = RunInner.fromJson(reader);
                } else if ("forceUpdateTag".equals(fieldName)) {
                    deserializedTaskRunPropertiesInner.forceUpdateTag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTaskRunPropertiesInner;
        });
    }
}
