// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.RunRequest;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The properties of task run.
 */
@Fluent
public final class TaskRunPropertiesInner {
    /*
     * The provisioning state of this task run
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * The request (parameters) for the run
     */
    @JsonProperty(value = "runRequest")
    private RunRequest runRequest;

    /*
     * The result of this task run
     */
    @JsonProperty(value = "runResult", access = JsonProperty.Access.WRITE_ONLY)
    private RunInner runResult;

    /*
     * How the run should be forced to rerun even if the run request configuration has not changed
     */
    @JsonProperty(value = "forceUpdateTag")
    private String forceUpdateTag;

    /**
     * Creates an instance of TaskRunPropertiesInner class.
     */
    public TaskRunPropertiesInner() {
    }

    /**
     * Get the provisioningState property: The provisioning state of this task run.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the runRequest property: The request (parameters) for the run.
     * 
     * @return the runRequest value.
     */
    public RunRequest runRequest() {
        return this.runRequest;
    }

    /**
     * Set the runRequest property: The request (parameters) for the run.
     * 
     * @param runRequest the runRequest value to set.
     * @return the TaskRunPropertiesInner object itself.
     */
    public TaskRunPropertiesInner withRunRequest(RunRequest runRequest) {
        this.runRequest = runRequest;
        return this;
    }

    /**
     * Get the runResult property: The result of this task run.
     * 
     * @return the runResult value.
     */
    public RunInner runResult() {
        return this.runResult;
    }

    /**
     * Get the forceUpdateTag property: How the run should be forced to rerun even if the run request configuration has
     * not changed.
     * 
     * @return the forceUpdateTag value.
     */
    public String forceUpdateTag() {
        return this.forceUpdateTag;
    }

    /**
     * Set the forceUpdateTag property: How the run should be forced to rerun even if the run request configuration has
     * not changed.
     * 
     * @param forceUpdateTag the forceUpdateTag value to set.
     * @return the TaskRunPropertiesInner object itself.
     */
    public TaskRunPropertiesInner withForceUpdateTag(String forceUpdateTag) {
        this.forceUpdateTag = forceUpdateTag;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (runRequest() != null) {
            runRequest().validate();
        }
        if (runResult() != null) {
            runResult().validate();
        }
    }
}
