// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The properties for updating triggers.
 */
@Fluent
public final class TriggerUpdateParameters {
    /*
     * The collection of timer triggers.
     */
    @JsonProperty(value = "timerTriggers")
    private List<TimerTriggerUpdateParameters> timerTriggers;

    /*
     * The collection of triggers based on source code repository.
     */
    @JsonProperty(value = "sourceTriggers")
    private List<SourceTriggerUpdateParameters> sourceTriggers;

    /*
     * The trigger based on base image dependencies.
     */
    @JsonProperty(value = "baseImageTrigger")
    private BaseImageTriggerUpdateParameters baseImageTrigger;

    /**
     * Creates an instance of TriggerUpdateParameters class.
     */
    public TriggerUpdateParameters() {
    }

    /**
     * Get the timerTriggers property: The collection of timer triggers.
     * 
     * @return the timerTriggers value.
     */
    public List<TimerTriggerUpdateParameters> timerTriggers() {
        return this.timerTriggers;
    }

    /**
     * Set the timerTriggers property: The collection of timer triggers.
     * 
     * @param timerTriggers the timerTriggers value to set.
     * @return the TriggerUpdateParameters object itself.
     */
    public TriggerUpdateParameters withTimerTriggers(List<TimerTriggerUpdateParameters> timerTriggers) {
        this.timerTriggers = timerTriggers;
        return this;
    }

    /**
     * Get the sourceTriggers property: The collection of triggers based on source code repository.
     * 
     * @return the sourceTriggers value.
     */
    public List<SourceTriggerUpdateParameters> sourceTriggers() {
        return this.sourceTriggers;
    }

    /**
     * Set the sourceTriggers property: The collection of triggers based on source code repository.
     * 
     * @param sourceTriggers the sourceTriggers value to set.
     * @return the TriggerUpdateParameters object itself.
     */
    public TriggerUpdateParameters withSourceTriggers(List<SourceTriggerUpdateParameters> sourceTriggers) {
        this.sourceTriggers = sourceTriggers;
        return this;
    }

    /**
     * Get the baseImageTrigger property: The trigger based on base image dependencies.
     * 
     * @return the baseImageTrigger value.
     */
    public BaseImageTriggerUpdateParameters baseImageTrigger() {
        return this.baseImageTrigger;
    }

    /**
     * Set the baseImageTrigger property: The trigger based on base image dependencies.
     * 
     * @param baseImageTrigger the baseImageTrigger value to set.
     * @return the TriggerUpdateParameters object itself.
     */
    public TriggerUpdateParameters withBaseImageTrigger(BaseImageTriggerUpdateParameters baseImageTrigger) {
        this.baseImageTrigger = baseImageTrigger;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (timerTriggers() != null) {
            timerTriggers().forEach(e -> e.validate());
        }
        if (sourceTriggers() != null) {
            sourceTriggers().forEach(e -> e.validate());
        }
        if (baseImageTrigger() != null) {
            baseImageTrigger().validate();
        }
    }
}
