// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The definition of Azure Monitoring log.
 */
@Fluent
public final class OperationLogSpecificationDefinition {
    /*
     * Log name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Log display name.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * Log blob duration.
     */
    @JsonProperty(value = "blobDuration")
    private String blobDuration;

    /**
     * Creates an instance of OperationLogSpecificationDefinition class.
     */
    public OperationLogSpecificationDefinition() {
    }

    /**
     * Get the name property: Log name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Log name.
     * 
     * @param name the name value to set.
     * @return the OperationLogSpecificationDefinition object itself.
     */
    public OperationLogSpecificationDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the displayName property: Log display name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Log display name.
     * 
     * @param displayName the displayName value to set.
     * @return the OperationLogSpecificationDefinition object itself.
     */
    public OperationLogSpecificationDefinition withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the blobDuration property: Log blob duration.
     * 
     * @return the blobDuration value.
     */
    public String blobDuration() {
        return this.blobDuration;
    }

    /**
     * Set the blobDuration property: Log blob duration.
     * 
     * @param blobDuration the blobDuration value to set.
     * @return the OperationLogSpecificationDefinition object itself.
     */
    public OperationLogSpecificationDefinition withBlobDuration(String blobDuration) {
        this.blobDuration = blobDuration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
