// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerregistry.models.RunRequest;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The properties of a task run update parameters.
 */
@Fluent
public final class TaskRunPropertiesUpdateParameters {
    /*
     * The request (parameters) for the new run
     */
    @JsonProperty(value = "runRequest")
    private RunRequest runRequest;

    /*
     * How the run should be forced to rerun even if the run request configuration has not changed
     */
    @JsonProperty(value = "forceUpdateTag")
    private String forceUpdateTag;

    /**
     * Creates an instance of TaskRunPropertiesUpdateParameters class.
     */
    public TaskRunPropertiesUpdateParameters() {
    }

    /**
     * Get the runRequest property: The request (parameters) for the new run.
     * 
     * @return the runRequest value.
     */
    public RunRequest runRequest() {
        return this.runRequest;
    }

    /**
     * Set the runRequest property: The request (parameters) for the new run.
     * 
     * @param runRequest the runRequest value to set.
     * @return the TaskRunPropertiesUpdateParameters object itself.
     */
    public TaskRunPropertiesUpdateParameters withRunRequest(RunRequest runRequest) {
        this.runRequest = runRequest;
        return this;
    }

    /**
     * Get the forceUpdateTag property: How the run should be forced to rerun even if the run request configuration has
     * not changed.
     * 
     * @return the forceUpdateTag value.
     */
    public String forceUpdateTag() {
        return this.forceUpdateTag;
    }

    /**
     * Set the forceUpdateTag property: How the run should be forced to rerun even if the run request configuration has
     * not changed.
     * 
     * @param forceUpdateTag the forceUpdateTag value to set.
     * @return the TaskRunPropertiesUpdateParameters object itself.
     */
    public TaskRunPropertiesUpdateParameters withForceUpdateTag(String forceUpdateTag) {
        this.forceUpdateTag = forceUpdateTag;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (runRequest() != null) {
            runRequest().validate();
        }
    }
}
