// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * An object that represents a cache rule for a container registry.
 */
@Fluent
public final class CacheRuleInner extends ProxyResource {
    /*
     * The properties of the cache rule.
     */
    @JsonProperty(value = "properties")
    private CacheRuleProperties innerProperties;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Creates an instance of CacheRuleInner class.
     */
    public CacheRuleInner() {
    }

    /**
     * Get the innerProperties property: The properties of the cache rule.
     * 
     * @return the innerProperties value.
     */
    private CacheRuleProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the credentialSetResourceId property: The ARM resource ID of the credential store which is associated with
     * the cache rule.
     * 
     * @return the credentialSetResourceId value.
     */
    public String credentialSetResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().credentialSetResourceId();
    }

    /**
     * Set the credentialSetResourceId property: The ARM resource ID of the credential store which is associated with
     * the cache rule.
     * 
     * @param credentialSetResourceId the credentialSetResourceId value to set.
     * @return the CacheRuleInner object itself.
     */
    public CacheRuleInner withCredentialSetResourceId(String credentialSetResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CacheRuleProperties();
        }
        this.innerProperties().withCredentialSetResourceId(credentialSetResourceId);
        return this;
    }

    /**
     * Get the sourceRepository property: Source repository pulled from upstream.
     * 
     * @return the sourceRepository value.
     */
    public String sourceRepository() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceRepository();
    }

    /**
     * Set the sourceRepository property: Source repository pulled from upstream.
     * 
     * @param sourceRepository the sourceRepository value to set.
     * @return the CacheRuleInner object itself.
     */
    public CacheRuleInner withSourceRepository(String sourceRepository) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CacheRuleProperties();
        }
        this.innerProperties().withSourceRepository(sourceRepository);
        return this;
    }

    /**
     * Get the targetRepository property: Target repository specified in docker pull command.
     * Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}.
     * 
     * @return the targetRepository value.
     */
    public String targetRepository() {
        return this.innerProperties() == null ? null : this.innerProperties().targetRepository();
    }

    /**
     * Set the targetRepository property: Target repository specified in docker pull command.
     * Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}.
     * 
     * @param targetRepository the targetRepository value to set.
     * @return the CacheRuleInner object itself.
     */
    public CacheRuleInner withTargetRepository(String targetRepository) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CacheRuleProperties();
        }
        this.innerProperties().withTargetRepository(targetRepository);
        return this;
    }

    /**
     * Get the creationDate property: The creation date of the cache rule.
     * 
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
