// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerregistry.fluent.models.TokenInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The result of a request to list tokens for a container registry.
 */
@Fluent
public final class TokenListResult {
    /*
     * The list of tokens. Since this list may be incomplete, the nextLink field should be used to request the next
     * list of tokens.
     */
    @JsonProperty(value = "value")
    private List<TokenInner> value;

    /*
     * The URI that can be used to request the next list of tokens.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of TokenListResult class.
     */
    public TokenListResult() {
    }

    /**
     * Get the value property: The list of tokens. Since this list may be incomplete, the nextLink field should be used
     * to request the next list of tokens.
     * 
     * @return the value value.
     */
    public List<TokenInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of tokens. Since this list may be incomplete, the nextLink field should be used
     * to request the next list of tokens.
     * 
     * @param value the value value to set.
     * @return the TokenListResult object itself.
     */
    public TokenListResult withValue(List<TokenInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI that can be used to request the next list of tokens.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI that can be used to request the next list of tokens.
     * 
     * @param nextLink the nextLink value to set.
     * @return the TokenListResult object itself.
     */
    public TokenListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
