// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerregistry.fluent.models.TaskRunPropertiesUpdateParameters;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * The parameters for updating a task run.
 */
@Fluent
public final class TaskRunUpdateParameters {
    /*
     * Identity for the resource.
     */
    @JsonProperty(value = "identity")
    private IdentityProperties identity;

    /*
     * The properties for updating a task run.
     */
    @JsonProperty(value = "properties")
    private TaskRunPropertiesUpdateParameters innerProperties;

    /*
     * The location of the resource
     */
    @JsonProperty(value = "location")
    private String location;

    /*
     * The ARM resource tags.
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    /**
     * Creates an instance of TaskRunUpdateParameters class.
     */
    public TaskRunUpdateParameters() {
    }

    /**
     * Get the identity property: Identity for the resource.
     * 
     * @return the identity value.
     */
    public IdentityProperties identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Identity for the resource.
     * 
     * @param identity the identity value to set.
     * @return the TaskRunUpdateParameters object itself.
     */
    public TaskRunUpdateParameters withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the innerProperties property: The properties for updating a task run.
     * 
     * @return the innerProperties value.
     */
    private TaskRunPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the location property: The location of the resource.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The location of the resource.
     * 
     * @param location the location value to set.
     * @return the TaskRunUpdateParameters object itself.
     */
    public TaskRunUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the tags property: The ARM resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The ARM resource tags.
     * 
     * @param tags the tags value to set.
     * @return the TaskRunUpdateParameters object itself.
     */
    public TaskRunUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the runRequest property: The request (parameters) for the new run.
     * 
     * @return the runRequest value.
     */
    public RunRequest runRequest() {
        return this.innerProperties() == null ? null : this.innerProperties().runRequest();
    }

    /**
     * Set the runRequest property: The request (parameters) for the new run.
     * 
     * @param runRequest the runRequest value to set.
     * @return the TaskRunUpdateParameters object itself.
     */
    public TaskRunUpdateParameters withRunRequest(RunRequest runRequest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskRunPropertiesUpdateParameters();
        }
        this.innerProperties().withRunRequest(runRequest);
        return this;
    }

    /**
     * Get the forceUpdateTag property: How the run should be forced to rerun even if the run request configuration has
     * not changed.
     * 
     * @return the forceUpdateTag value.
     */
    public String forceUpdateTag() {
        return this.innerProperties() == null ? null : this.innerProperties().forceUpdateTag();
    }

    /**
     * Set the forceUpdateTag property: How the run should be forced to rerun even if the run request configuration has
     * not changed.
     * 
     * @param forceUpdateTag the forceUpdateTag value to set.
     * @return the TaskRunUpdateParameters object itself.
     */
    public TaskRunUpdateParameters withForceUpdateTag(String forceUpdateTag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskRunPropertiesUpdateParameters();
        }
        this.innerProperties().withForceUpdateTag(forceUpdateTag);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
