// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * The properties of a cache rule.
 */
@Fluent
public final class CacheRuleProperties {
    /*
     * The ARM resource ID of the credential store which is associated with the cache rule.
     */
    @JsonProperty(value = "credentialSetResourceId")
    private String credentialSetResourceId;

    /*
     * Source repository pulled from upstream.
     */
    @JsonProperty(value = "sourceRepository")
    private String sourceRepository;

    /*
     * Target repository specified in docker pull command.
     * Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}
     */
    @JsonProperty(value = "targetRepository")
    private String targetRepository;

    /*
     * The creation date of the cache rule.
     */
    @JsonProperty(value = "creationDate", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;

    /*
     * Provisioning state of the resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of CacheRuleProperties class.
     */
    public CacheRuleProperties() {
    }

    /**
     * Get the credentialSetResourceId property: The ARM resource ID of the credential store which is associated with
     * the cache rule.
     * 
     * @return the credentialSetResourceId value.
     */
    public String credentialSetResourceId() {
        return this.credentialSetResourceId;
    }

    /**
     * Set the credentialSetResourceId property: The ARM resource ID of the credential store which is associated with
     * the cache rule.
     * 
     * @param credentialSetResourceId the credentialSetResourceId value to set.
     * @return the CacheRuleProperties object itself.
     */
    public CacheRuleProperties withCredentialSetResourceId(String credentialSetResourceId) {
        this.credentialSetResourceId = credentialSetResourceId;
        return this;
    }

    /**
     * Get the sourceRepository property: Source repository pulled from upstream.
     * 
     * @return the sourceRepository value.
     */
    public String sourceRepository() {
        return this.sourceRepository;
    }

    /**
     * Set the sourceRepository property: Source repository pulled from upstream.
     * 
     * @param sourceRepository the sourceRepository value to set.
     * @return the CacheRuleProperties object itself.
     */
    public CacheRuleProperties withSourceRepository(String sourceRepository) {
        this.sourceRepository = sourceRepository;
        return this;
    }

    /**
     * Get the targetRepository property: Target repository specified in docker pull command.
     * Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}.
     * 
     * @return the targetRepository value.
     */
    public String targetRepository() {
        return this.targetRepository;
    }

    /**
     * Set the targetRepository property: Target repository specified in docker pull command.
     * Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}.
     * 
     * @param targetRepository the targetRepository value to set.
     * @return the CacheRuleProperties object itself.
     */
    public CacheRuleProperties withTargetRepository(String targetRepository) {
        this.targetRepository = targetRepository;
        return this;
    }

    /**
     * Get the creationDate property: The creation date of the cache rule.
     * 
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
